/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.jce;

import java.util.Enumeration;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.python.bouncycastle.asn1.x9.X9ECParameters;
import org.python.bouncycastle.jce.spec.ECNamedCurveParameterSpec;

public class ECGOST3410NamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String string2) {
        X9ECParameters x9ECParameters = ECGOST3410NamedCurves.getByNameX9(string2);
        if (x9ECParameters == null) {
            try {
                x9ECParameters = ECGOST3410NamedCurves.getByOIDX9(new ASN1ObjectIdentifier(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        if (x9ECParameters == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(string2, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
    }

    public static Enumeration getNames() {
        return ECGOST3410NamedCurves.getNames();
    }
}

