/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.model.EventType;
import java.io.Serializable;
import java.util.Objects;

public class DomainObjectChangeRecord
implements Serializable {
    private EventType eventType;
    private Object oldValue;
    private Object newValue;

    public DomainObjectChangeRecord(EventType eventType) {
        this(eventType, null, null);
    }

    public DomainObjectChangeRecord(EventType eventType, Object oldValue, Object newValue) {
        this.eventType = Objects.requireNonNull(eventType);
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append(": event = ");
        buf.append(this.eventType);
        if (this.oldValue != null) {
            buf.append(", old = ");
            buf.append(this.oldValue);
        }
        if (this.newValue != null) {
            buf.append(", new = ");
            buf.append(this.newValue);
        }
        return buf.toString();
    }
}

