/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class FilterAtom {
    public BSimFilterType type;
    public String value;

    public FilterAtom() {
    }

    public FilterAtom(BSimFilterType type, String value) {
        this.type = type;
        this.value = type.normalizeValue(value);
    }

    public FilterAtom clone() {
        FilterAtom res = new FilterAtom();
        res.type = this.type;
        res.value = this.value;
        return res;
    }

    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append("<atom");
        this.type.saveXml(fwrite);
        fwrite.append('>');
        SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.value);
        fwrite.append("</atom>\n");
    }

    public void restoreXml(XmlPullParser parser) {
        XmlElement el = parser.start(new String[]{"atom"});
        this.type = BSimFilterType.nameToType(el);
        this.value = parser.end().getText();
        if (this.type.isValidValue(this.value)) {
            this.value = this.type.normalizeValue(this.value);
        } else {
            this.type = BSimFilterType.getBlank();
        }
    }

    public String getInfoString() {
        if (this.type.isBlank()) {
            return null;
        }
        String res = this.type.toString() + " " + this.value;
        return res;
    }

    public boolean evaluate(ExecutableRecord rec) {
        if (this.value == null) {
            return true;
        }
        return this.type.evaluate(rec, this.value);
    }

    public boolean isValid() {
        return this.value != null;
    }

    public String getValueString() {
        return this.value;
    }
}

