/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.AddBitFieldAction;
import ghidra.app.plugin.core.compositeeditor.ApplyAction;
import ghidra.app.plugin.core.compositeeditor.ArrayAction;
import ghidra.app.plugin.core.compositeeditor.BitFieldEditorDialog;
import ghidra.app.plugin.core.compositeeditor.ClearAction;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.compositeeditor.CreateInternalStructureAction;
import ghidra.app.plugin.core.compositeeditor.DeleteAction;
import ghidra.app.plugin.core.compositeeditor.DuplicateAction;
import ghidra.app.plugin.core.compositeeditor.DuplicateMultipleAction;
import ghidra.app.plugin.core.compositeeditor.EditBitFieldAction;
import ghidra.app.plugin.core.compositeeditor.EditComponentAction;
import ghidra.app.plugin.core.compositeeditor.EditFieldAction;
import ghidra.app.plugin.core.compositeeditor.FindReferencesToStructureFieldAction;
import ghidra.app.plugin.core.compositeeditor.HexNumbersAction;
import ghidra.app.plugin.core.compositeeditor.InsertUndefinedAction;
import ghidra.app.plugin.core.compositeeditor.MoveDownAction;
import ghidra.app.plugin.core.compositeeditor.MoveUpAction;
import ghidra.app.plugin.core.compositeeditor.PointerAction;
import ghidra.app.plugin.core.compositeeditor.RedoChangeAction;
import ghidra.app.plugin.core.compositeeditor.ShowComponentPathAction;
import ghidra.app.plugin.core.compositeeditor.ShowDataTypeInTreeAction;
import ghidra.app.plugin.core.compositeeditor.StructureEditorModel;
import ghidra.app.plugin.core.compositeeditor.StructureEditorPanel;
import ghidra.app.plugin.core.compositeeditor.UndoChangeAction;
import ghidra.app.plugin.core.compositeeditor.UnpackageAction;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.util.Msg;
import java.awt.Component;
import javax.swing.Icon;

public class StructureEditorProvider
extends CompositeEditorProvider<Structure, StructureEditorModel> {
    private BitFieldEditorDialog bitFieldEditor;
    protected static final Icon STRUCTURE_EDITOR_ICON = new GIcon("icon.plugin.composite.editor.provider.structure");

    public StructureEditorProvider(Plugin plugin, Structure structureDataType, boolean showHexNumbers) {
        super(plugin);
        if (structureDataType.isDeleted()) {
            throw new IllegalArgumentException("Structure has been deleted: " + structureDataType.getPathName());
        }
        this.setIcon(STRUCTURE_EDITOR_ICON);
        this.editorModel = new StructureEditorModel(this, showHexNumbers);
        this.editorModel.load(structureDataType);
        this.initializeActions();
        this.editorPanel = new StructureEditorPanel((StructureEditorModel)this.editorModel, this);
        plugin.getTool().addComponentProvider((ComponentProvider)this, true);
        this.updateTitle();
        this.addActionsToTool();
        this.editorPanel.getTable().requestFocus();
        this.editorModel.selectionChanged();
    }

    @Override
    public String getName() {
        return "Structure Editor";
    }

    @Override
    protected CompositeEditorTableAction[] createActions() {
        return new CompositeEditorTableAction[]{new ApplyAction(this), new UndoChangeAction(this), new RedoChangeAction(this), new InsertUndefinedAction(this), new MoveUpAction(this), new MoveDownAction(this), new ClearAction(this), new DuplicateAction(this), new DuplicateMultipleAction(this), new DeleteAction(this), new PointerAction(this), new ArrayAction(this), new FindReferencesToStructureFieldAction(this), new UnpackageAction(this), new EditComponentAction(this), new EditFieldAction(this), new HexNumbersAction(this), new CreateInternalStructureAction(this), new ShowComponentPathAction(this), new AddBitFieldAction(this), new EditBitFieldAction(this), new ShowDataTypeInTreeAction(this)};
    }

    @Override
    public String getHelpName() {
        return "Structure_Editor";
    }

    @Override
    public String getHelpTopic() {
        return "DataTypeEditors";
    }

    @Override
    protected void closeDependentEditors() {
        if (this.bitFieldEditor != null && this.bitFieldEditor.isVisible()) {
            this.bitFieldEditor.close();
        }
    }

    private void refreshTableAndSelection(int ordinal) {
        this.editorModel.notifyCompositeChanged();
        this.editorModel.setSelection(new int[]{ordinal, ordinal});
    }

    void showAddBitFieldEditor() {
        int[] selectedRows = this.editorModel.getSelectedRows();
        if (this.editorPanel.hasInvalidEntry() || this.editorPanel.hasUncomittedEntry() || selectedRows.length != 1 || ((Structure)this.editorModel.viewComposite).isPackingEnabled()) {
            Msg.error((Object)this, (Object)"Unsupported add bitfield editor use");
            return;
        }
        this.bitFieldEditor = new BitFieldEditorDialog(this.editorModel.viewComposite, this.dtmService, -(selectedRows[0] + 1), this.editorModel.showHexNumbers, ordinal -> this.refreshTableAndSelection(ordinal));
        DockingWindowManager.showDialog((Component)this.editorPanel, (DialogComponentProvider)this.bitFieldEditor);
        this.requestTableFocus();
    }

    void showBitFieldEditor() {
        DataTypeComponent dtComponent = this.getSelectedNonPackedBitFieldComponent();
        if (dtComponent == null) {
            Msg.error((Object)this, (Object)"Unsupported bitfield editor use");
            return;
        }
        this.bitFieldEditor = new BitFieldEditorDialog(this.editorModel.viewComposite, this.dtmService, dtComponent.getOrdinal(), this.editorModel.showHexNumbers, ordinal -> this.refreshTableAndSelection(ordinal));
        DockingWindowManager.showDialog((Component)this.editorPanel, (DialogComponentProvider)this.bitFieldEditor);
        this.requestTableFocus();
    }

    DataTypeComponent getSelectedNonPackedBitFieldComponent() {
        DataTypeComponent dtComponent;
        int rowIndex;
        if (!((Structure)this.editorModel.viewComposite).isPackingEnabled() && this.editorModel.getNumSelectedRows() == 1 && (rowIndex = this.editorModel.getSelectedRows()[0]) < this.editorModel.getNumComponents() && (dtComponent = this.editorModel.getComponent(rowIndex)).isBitFieldComponent()) {
            return dtComponent;
        }
        return null;
    }
}

