/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reloc;

import ghidra.app.plugin.core.reloc.InstructionStasher;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.classfinder.ExtensionPoint;

public abstract class RelocationFixupHandler
implements ExtensionPoint {
    protected RelocationFixupHandler() {
    }

    public abstract boolean processRelocation(Program var1, Relocation var2, Address var3, Address var4) throws MemoryAccessException, CodeUnitInsertionException;

    public abstract boolean handlesProgram(Program var1);

    protected boolean process32BitRelocation(Program program, Relocation relocation, Address oldImageBase, Address newImageBase) throws MemoryAccessException, CodeUnitInsertionException {
        long diff = newImageBase.subtract(oldImageBase);
        Address address = relocation.getAddress();
        Memory memory = program.getMemory();
        int value = memory.getInt(address);
        int newValue = (int)((long)value + diff);
        InstructionStasher instructionStasher = new InstructionStasher(program, address);
        memory.setInt(address, newValue);
        instructionStasher.restore();
        return true;
    }

    public boolean process64BitRelocation(Program program, Relocation relocation, Address oldImageBase, Address newImageBase) throws MemoryAccessException, CodeUnitInsertionException {
        long diff = newImageBase.subtract(oldImageBase);
        Address address = relocation.getAddress();
        Memory memory = program.getMemory();
        long value = memory.getLong(address);
        long newValue = value + diff;
        InstructionStasher instructionStasher = new InstructionStasher(program, address);
        memory.setLong(address, newValue);
        instructionStasher.restore();
        return true;
    }
}

