/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.CoffSymbolAux;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CoffSymbolAuxArray
implements CoffSymbolAux {
    private int tagIndex;
    private short lineNumber;
    private short arraySize;
    private short firstDimension;
    private short secondDimension;
    private short thirdDimension;
    private short fourthDimension;
    private byte[] unused;

    CoffSymbolAuxArray(BinaryReader reader) throws IOException {
        this.tagIndex = reader.readNextInt();
        this.lineNumber = reader.readNextShort();
        this.arraySize = reader.readNextShort();
        this.firstDimension = reader.readNextShort();
        this.secondDimension = reader.readNextShort();
        this.thirdDimension = reader.readNextShort();
        this.fourthDimension = reader.readNextShort();
        this.unused = reader.readNextByteArray(2);
    }

    public int getTagIndex() {
        return this.tagIndex;
    }

    public short getLineNumber() {
        return this.lineNumber;
    }

    public short getArraySize() {
        return this.arraySize;
    }

    public short getFirstDimension() {
        return this.firstDimension;
    }

    public short getSecondDimension() {
        return this.secondDimension;
    }

    public short getThirdDimension() {
        return this.thirdDimension;
    }

    public short getFourthDimension() {
        return this.fourthDimension;
    }

    public byte[] getUnused() {
        return this.unused;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(this);
    }
}

