/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_InstanceVariable;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ObjectiveC1_InstanceVariableList
implements StructConverter {
    public static final String NAME = "objc_method_list";
    private ObjectiveC1_State _state;
    private long _index;
    private int ivar_count;
    private List<ObjectiveC1_InstanceVariable> ivar_list = new ArrayList<ObjectiveC1_InstanceVariable>();

    ObjectiveC1_InstanceVariableList(ObjectiveC1_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        if (this._index == 0L) {
            return;
        }
        this.ivar_count = reader.readNextInt();
        for (int i = 0; i < this.ivar_count; ++i) {
            this.ivar_list.add(new ObjectiveC1_InstanceVariable(state, reader));
        }
    }

    public int getInstanceVariableCount() {
        return this.ivar_count;
    }

    public List<ObjectiveC1_InstanceVariable> getInstanceVariables() {
        return this.ivar_list;
    }

    public static DataType toGenericDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add(DWORD, "ivar_count", null);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_ivar_list_" + this.ivar_count + "_", 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add(DWORD, "ivar_count", null);
        if (this.ivar_count > 0) {
            DataType dt = this.ivar_list.get(0).toDataType();
            struct.add((DataType)new ArrayDataType(dt, this.ivar_count, dt.getLength()), "ivar_list", null);
        }
        return struct;
    }

    public void applyTo() throws Exception {
        if (this._index == 0L) {
            return;
        }
        if (this._state.beenApplied.contains(this._index)) {
            return;
        }
        this._state.beenApplied.add(this._index);
        Address address = this._state.program.getAddressFactory().getDefaultAddressSpace().getAddress(this._index);
        DataType dt = this.toDataType();
        this._state.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this._state.program.getListing().createData(address, dt);
    }
}

