/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.navigation;

import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.gotoquery.GoToHelper;
import ghidra.app.services.GoToOverrideService;
import ghidra.app.services.GoToService;
import ghidra.app.services.GoToServiceListener;
import ghidra.app.services.QueryData;
import ghidra.app.util.navigation.GoToQuery;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.task.TaskMonitor;

public class GoToServiceImpl
implements GoToService {
    private final Navigatable defaultNavigatable;
    private GoToOverrideService override;
    private GoToHelper helper;
    protected final Plugin plugin;

    public GoToServiceImpl(Plugin plugin, Navigatable defaultNavigatable) {
        this.plugin = plugin;
        this.defaultNavigatable = defaultNavigatable;
        this.helper = new GoToHelper(plugin.getTool());
    }

    @Override
    public GoToOverrideService getOverrideService() {
        return this.override;
    }

    @Override
    public boolean goTo(ProgramLocation loc) {
        return this.helper.goTo(this.defaultNavigatable, loc, loc.getProgram());
    }

    @Override
    public boolean goTo(ProgramLocation loc, Program program) {
        return this.helper.goTo(this.defaultNavigatable, loc, program);
    }

    @Override
    public boolean goTo(Navigatable navigatable, ProgramLocation loc, Program program) {
        if (navigatable == null || navigatable.isConnected()) {
            navigatable = this.defaultNavigatable;
        }
        return this.helper.goTo(navigatable, loc, program);
    }

    @Override
    public boolean goTo(Navigatable navigatable, Address goToAddress) {
        if (goToAddress == null) {
            return false;
        }
        if (navigatable == null) {
            navigatable = this.defaultNavigatable;
        }
        Program program = navigatable.getProgram();
        Address currentAddress = navigatable.getLocation().getAddress();
        ProgramLocation location = this.helper.getLocation(program, currentAddress, goToAddress);
        if (navigatable.isConnected()) {
            navigatable = this.defaultNavigatable;
        }
        return this.helper.goTo(navigatable, location, program);
    }

    @Override
    public boolean goTo(Navigatable navigatable, Program program, Address address, Address refAddress) {
        ProgramLocation location = this.helper.getLocation(program, refAddress, address);
        return this.helper.goTo(navigatable, location, program);
    }

    @Override
    public boolean goTo(Address currentAddress, Address goToAddress) {
        Program program = this.defaultNavigatable.getProgram();
        ProgramLocation location = this.helper.getLocation(program, currentAddress, goToAddress);
        return this.helper.goTo(this.defaultNavigatable, location, program);
    }

    @Override
    public boolean goTo(Address goToAddress) {
        if (goToAddress == null) {
            return false;
        }
        ProgramLocation programLocation = null;
        Program program = this.defaultNavigatable.getProgram();
        if (this.override != null) {
            programLocation = this.override.goTo(goToAddress);
        }
        if (programLocation == null) {
            programLocation = GoToHelper.getProgramLocationForAddress(goToAddress, program);
        } else {
            program = programLocation.getProgram();
        }
        return this.helper.goTo(this.defaultNavigatable, programLocation, program);
    }

    @Override
    public boolean goTo(Address goToAddress, Program program) {
        ProgramLocation location = GoToHelper.getProgramLocationForAddress(goToAddress, program);
        return this.helper.goTo(this.defaultNavigatable, location, program);
    }

    @Override
    public boolean goToExternalLocation(ExternalLocation extLoc, boolean checkNavigationOption) {
        return this.helper.goToExternalLocation(this.defaultNavigatable, extLoc, checkNavigationOption);
    }

    @Override
    public boolean goToExternalLocation(Navigatable navigatable, ExternalLocation extLoc, boolean checkNavigationOption) {
        return this.helper.goToExternalLocation(navigatable, extLoc, checkNavigationOption);
    }

    @Override
    public boolean goToQuery(Navigatable navigatable, Address fromAddr, QueryData queryData, GoToServiceListener listener, TaskMonitor monitor) {
        if (navigatable == null || navigatable.isConnected()) {
            navigatable = this.defaultNavigatable;
        }
        GoToQuery query = new GoToQuery(navigatable, this.plugin, this, queryData, fromAddr, this.helper.getOptions(), monitor);
        boolean result = query.processQuery();
        if (listener != null) {
            listener.gotoCompleted(queryData.getQueryString(), result);
        }
        return result;
    }

    @Override
    public boolean goToQuery(Address fromAddr, QueryData queryData, GoToServiceListener listener, TaskMonitor monitor) {
        return this.goToQuery(this.defaultNavigatable, fromAddr, queryData, listener, monitor);
    }

    @Override
    public void setOverrideService(GoToOverrideService override) {
        this.override = override;
    }

    @Override
    public Navigatable getDefaultNavigatable() {
        return this.defaultNavigatable;
    }
}

