/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import generic.theme.GColor;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Function;
import ghidra.program.util.FunctionPurgeFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;

public class FunctionPurgeFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Function Purge";
    public static final GColor COLOR = new GColor("color.fg.listing.function.purge");

    public FunctionPurgeFieldFactory() {
        super(FIELD_NAME);
    }

    private FunctionPurgeFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel newModel, ListingHighlightProvider newHlProvider, ToolOptions toolOptions, ToolOptions fieldOptions) {
        return new FunctionPurgeFieldFactory(newModel, newHlProvider, (Options)toolOptions, (Options)fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Function)) {
            return null;
        }
        Function func = (Function)obj;
        Object stringDepth = "UNK";
        int depth = func.getStackPurgeSize();
        switch (depth) {
            case 0x7FFFFFFE: {
                stringDepth = "INV";
                break;
            }
            case 0x7FFFFFFF: {
                stringDepth = "UNK";
                break;
            }
            default: {
                stringDepth = depth < 0 ? "-" + Integer.toHexString(-depth) : Integer.toHexString(depth);
            }
        }
        AttributedString as = new AttributedString((String)stringDepth, (Color)COLOR, this.getMetrics());
        TextFieldElement text = new TextFieldElement(as, 0, 0);
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)text, this.startX + varWidth, this.width, this.hlProvider);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (loc instanceof FunctionPurgeFieldLocation) {
            FunctionPurgeFieldLocation functionPurgeLoc = (FunctionPurgeFieldLocation)loc;
            return new FieldLocation(index, fieldNum, 0, functionPurgeLoc.getCharOffset());
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof Function) || row < 0 || col < 0) {
            return null;
        }
        Function func = (Function)obj;
        return new FunctionPurgeFieldLocation(func.getProgram(), func.getEntryPoint(), col);
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Function.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 2;
    }
}

