/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cramfs;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.cramfs.CramFsInode;
import ghidra.file.formats.cramfs.CramFsSuper;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class CramFsAnalyzer
extends AbstractAnalyzer {
    public CramFsAnalyzer() {
        super("CramFS Analyzer", "Annotates CramFS binaries", AnalyzerType.BYTE_ANALYZER);
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public boolean canAnalyze(Program program) {
        try {
            if (!"Raw Binary".equals(program.getExecutableFormat())) {
                return false;
            }
            Language language = program.getLanguage();
            if (language.getProcessor() == Processor.findOrPossiblyCreateProcessor((String)"DATA") && !language.isBigEndian()) {
                return false;
            }
            int magic = program.getMemory().getInt(program.getMinAddress());
            return magic == 684539205;
        }
        catch (MemoryAccessException memoryAccessException) {
            return false;
        }
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Address minAddress = program.getMinAddress();
        boolean isLE = !program.getLanguage().isBigEndian();
        try (MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), minAddress);){
            BinaryReader reader = new BinaryReader((ByteProvider)provider, isLE);
            CramFsSuper cramFsSuper = new CramFsSuper(reader);
            DataType dataType = cramFsSuper.toDataType();
            program.getListing().createData(minAddress, dataType);
            program.getListing().setComment(minAddress, CommentType.PLATE, cramFsSuper.getRoot().toString());
            int offset = cramFsSuper.getRoot().getOffsetAdjusted();
            for (int i = 0; i < cramFsSuper.getFsid().getFiles() - 1; ++i) {
                monitor.checkCancelled();
                reader.setPointerIndex(offset);
                Address inodeAddress = minAddress.add((long)offset);
                CramFsInode newInode = new CramFsInode(reader);
                if (newInode.isFile()) {
                    Address inodeDataAddress = minAddress.add((long)newInode.getOffsetAdjusted());
                    program.getListing().setComment(inodeDataAddress, CommentType.PLATE, newInode.getName() + " Data/Bytes\n");
                }
                DataType inodeDataType = newInode.toDataType();
                program.getListing().createData(inodeAddress, inodeDataType);
                program.getListing().setComment(inodeAddress, CommentType.PLATE, newInode.getName() + "\n" + newInode.toString());
                offset += inodeDataType.getLength();
            }
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
            return false;
        }
        return true;
    }
}

