/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.image;

import ghidra.file.image.GImage;
import ghidra.file.image.GImageFormat;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class GImageConverter {
    private File imageFile;

    public GImageConverter(File imageFile) {
        this.imageFile = imageFile;
    }

    public byte[] toBufferedImage() throws IOException {
        BufferedImage bufferedImage = ImageIO.read(this.imageFile);
        if (bufferedImage == null) {
            throw new IOException("No image provider for " + this.imageFile.getName());
        }
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        Raster raster = bufferedImage.getData();
        int[] pixels = raster.getPixels(0, 0, width, height, (int[])null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int p = 0; p < pixels.length; p += 4) {
            int blue = pixels[p + 0] & 0xFF;
            int green = pixels[p + 1] & 0xFF;
            int red = pixels[p + 2] & 0xFF;
            int alpha = pixels[p + 3] & 0xFF;
            out.write(red);
            out.write(green);
            out.write(blue);
            out.write(alpha ^= 0xFFFFFFFF);
        }
        out.close();
        return out.toByteArray();
    }

    private int getWidth() throws IOException {
        BufferedImage bufferedImage = ImageIO.read(this.imageFile);
        return bufferedImage.getWidth();
    }

    private int getHeight() throws IOException {
        BufferedImage bufferedImage = ImageIO.read(this.imageFile);
        return bufferedImage.getHeight();
    }

    public static void main(String[] args) throws Exception {
        GImageFormat format = GImageFormat.GRAY_ALPHA_2BYTE;
        String img = "~/Mobile_Devices/images/apple_logo_line_1.PNG";
        String raw = "~/Mobile_Devices/images/apple_logo_line_1.RAW";
        File imageFile = new File(img);
        GImageConverter converter = new GImageConverter(imageFile);
        byte[] imageBytes = converter.toBufferedImage();
        FileOutputStream rawOUT = new FileOutputStream(raw);
        ((OutputStream)rawOUT).write(imageBytes);
        ((OutputStream)rawOUT).close();
        File rawFile = new File(raw);
        FileInputStream rawIN = new FileInputStream(raw);
        GImage image = new GImage(converter.getWidth(), converter.getHeight(), format, rawIN, rawFile.length());
        ((InputStream)rawIN).close();
        final Icon icon = image.toPNG();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, icon, "icon", 1);
            }
        });
    }
}

