/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import java.util.ArrayList;
import java.util.List;

public class AnnotationMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4121;
    private long offset;
    private int segment;
    private List<String> annotationStringList = new ArrayList<String>();

    public AnnotationMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.offset = reader.parseUnsignedIntVal();
        this.segment = pdb.parseSegment(reader);
        int count = reader.parseUnsignedShortVal();
        for (int i = 0; i < count; ++i) {
            String string = reader.parseString(pdb, StringParseType.StringUtf8Nt);
            this.annotationStringList.add(string);
        }
        if (this.annotationStringList.size() != count) {
            throw new PdbException("We are not expecting this--needs investigation");
        }
        reader.align4();
    }

    @Override
    public int getPdbId() {
        return 4121;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: [%04X:%08X]\n", this.getSymbolTypeName(), this.segment, this.offset));
        int count = 0;
        for (String string : this.annotationStringList) {
            builder.append(String.format("%5d: %s\n", count++, string));
        }
    }

    @Override
    protected String getSymbolTypeName() {
        return "ANNOTATION";
    }
}

