/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;

public enum FlowOverride {
    NONE,
    BRANCH,
    CALL,
    CALL_RETURN,
    RETURN;


    public static FlowOverride getFlowOverride(int ordinal) {
        for (FlowOverride value : FlowOverride.values()) {
            if (value.ordinal() != ordinal) continue;
            return value;
        }
        return NONE;
    }

    public static FlowType getModifiedFlowType(FlowType originalFlowType, FlowOverride flowOverride) {
        FlowType flowType = originalFlowType;
        if (flowOverride == NONE || !flowType.isJump() && !flowType.isTerminal() && !flowType.isCall()) {
            return flowType;
        }
        if (flowOverride == BRANCH) {
            if (flowType.isJump()) {
                return flowType;
            }
            if (flowType.isConditional()) {
                if (flowType.isTerminal()) {
                    return RefType.CONDITIONAL_COMPUTED_JUMP;
                }
                return RefType.CONDITIONAL_JUMP;
            }
            if (flowType.isComputed()) {
                return RefType.COMPUTED_JUMP;
            }
            if (flowType.isTerminal()) {
                return RefType.COMPUTED_JUMP;
            }
            return RefType.UNCONDITIONAL_JUMP;
        }
        if (flowOverride == CALL) {
            if (flowType.isCall()) {
                return flowType;
            }
            if (flowType.isConditional()) {
                if (flowType.isTerminal() && (flowType.isCall() || flowType.isJump())) {
                    return RefType.CONDITIONAL_CALL_TERMINATOR;
                }
                if (flowType.isTerminal()) {
                    return RefType.CONDITIONAL_COMPUTED_CALL;
                }
                return RefType.CONDITIONAL_CALL;
            }
            if (flowType.isComputed()) {
                if (flowType.isTerminal() && (flowType.isCall() || flowType.isJump())) {
                    return RefType.COMPUTED_CALL_TERMINATOR;
                }
                return RefType.COMPUTED_CALL;
            }
            if (flowType.isTerminal() && (flowType.isCall() || flowType.isJump())) {
                return RefType.CALL_TERMINATOR;
            }
            if (flowType.isTerminal()) {
                return RefType.COMPUTED_CALL;
            }
            return RefType.UNCONDITIONAL_CALL;
        }
        if (flowOverride == CALL_RETURN) {
            if (flowType.isConditional()) {
                if (flowType.isComputed()) {
                    return RefType.CONDITIONAL_COMPUTED_CALL;
                }
                if (flowType.isTerminal()) {
                    return RefType.COMPUTED_CALL_TERMINATOR;
                }
                return flowType;
            }
            if (flowType.isComputed()) {
                return RefType.COMPUTED_CALL_TERMINATOR;
            }
            if (flowType.isTerminal()) {
                return RefType.COMPUTED_CALL_TERMINATOR;
            }
            return RefType.CALL_TERMINATOR;
        }
        if (flowOverride == RETURN) {
            if (flowType.isConditional()) {
                return RefType.CONDITIONAL_TERMINATOR;
            }
            return RefType.TERMINATOR;
        }
        return flowType;
    }
}

