/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.values;

import docking.widgets.textfield.FloatingPointTextField;
import docking.widgets.values.AbstractValue;
import javax.swing.JComponent;

public class DoubleValue
extends AbstractValue<Double> {
    private FloatingPointTextField field;

    public DoubleValue(String name) {
        this(name, null);
    }

    public DoubleValue(String name, Double defaultValue) {
        super(name, defaultValue);
    }

    @Override
    public JComponent getComponent() {
        if (this.field == null) {
            this.field = new FloatingPointTextField(20);
        }
        return this.field;
    }

    @Override
    protected void updateValueFromComponent() {
        String text = this.field.getText();
        if (this.getValue() == null && text.equals("")) {
            return;
        }
        this.setValue(this.field.getValue());
    }

    @Override
    protected void updateComponentFromValue() {
        Double value = (Double)this.getValue();
        if (value == null) {
            this.field.setText("");
            return;
        }
        this.field.setValue(value);
    }

    @Override
    public Double fromString(String valueString) {
        return Double.parseDouble(valueString);
    }
}

