/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.repulsion;

import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Random;
import org.jungrapht.visualization.layout.algorithms.SpringLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.repulsion.BarnesHutRepulsion;
import org.jungrapht.visualization.layout.algorithms.repulsion.StandardSpringRepulsion;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.quadtree.BarnesHutQuadTree;
import org.jungrapht.visualization.layout.quadtree.ForceObject;

public class BarnesHutSpringRepulsion<V>
extends StandardSpringRepulsion<V, BarnesHutSpringRepulsion<V>, Builder<V>>
implements BarnesHutRepulsion<V, BarnesHutSpringRepulsion<V>, Builder<V>> {
    protected BarnesHutQuadTree<V> tree;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static Builder barnesHutBuilder() {
        return BarnesHutSpringRepulsion.builder();
    }

    protected BarnesHutSpringRepulsion(Builder<V> builder) {
        super(builder);
        this.tree = builder.tree;
    }

    @Override
    public void step() {
        this.tree.rebuild(this.layoutModel.getGraph().vertexSet(), this.layoutModel);
    }

    @Override
    public void calculateRepulsion() {
        try {
            for (final Object vertex : this.vertexSet) {
                if (this.layoutModel.isLocked(vertex)) continue;
                SpringLayoutAlgorithm.SpringVertexData svd = this.springVertexData.getOrDefault(vertex, new SpringLayoutAlgorithm.SpringVertexData());
                Point forcePoint = (Point)this.layoutModel.apply(vertex);
                ForceObject nodeForceObject = new ForceObject(vertex, forcePoint.x, forcePoint.y){

                    protected void addForceFrom(ForceObject other) {
                        if (other == null || vertex == other.getElement()) {
                            return;
                        }
                        Point p = this.p;
                        Point p2 = other.p;
                        if (p == null || p2 == null) {
                            return;
                        }
                        double vx = p.x - p2.x;
                        double vy = p.y - p2.y;
                        double distanceSq = p.distanceSquared(p2);
                        if (distanceSq == 0.0) {
                            this.f = this.f.add(BarnesHutSpringRepulsion.this.random.nextDouble(), BarnesHutSpringRepulsion.this.random.nextDouble());
                        } else if (distanceSq < (double)BarnesHutSpringRepulsion.this.repulsionRangeSquared) {
                            double factor = 1.0;
                            this.f = this.f.add(factor * vx / distanceSq, factor * vy / distanceSq);
                        }
                    }
                };
                this.tree.applyForcesTo(nodeForceObject);
                Point f = Point.of(nodeForceObject.f.x, nodeForceObject.f.y);
                double dlen = f.x * f.x + f.y * f.y;
                if (!(dlen > 0.0)) continue;
                dlen = Math.sqrt(dlen) / 2.0;
                svd.repulsiondx += f.x / dlen;
                svd.repulsiondy += f.y / dlen;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calculateRepulsion();
        }
    }

    public static class Builder<V>
    extends StandardSpringRepulsion.Builder<V, BarnesHutSpringRepulsion<V>, Builder<V>>
    implements BarnesHutRepulsion.Builder<V, BarnesHutSpringRepulsion<V>, Builder<V>> {
        private double theta = 0.5;
        private BarnesHutQuadTree<V> tree = new BarnesHutQuadTree();

        @Override
        public Builder<V> layoutModel(LayoutModel<V> layoutModel) {
            this.layoutModel = layoutModel;
            this.tree = BarnesHutQuadTree.builder().bounds(layoutModel.getWidth(), layoutModel.getHeight()).theta(this.theta).build();
            return this;
        }

        @Override
        public Builder<V> theta(double theta) {
            this.theta = theta;
            return this;
        }

        @Override
        public Builder<V> nodeData(Map<V, SpringLayoutAlgorithm.SpringVertexData> springVertexData) {
            this.springVertexData = springVertexData;
            return this;
        }

        @Override
        public Builder<V> repulsionRangeSquared(int repulsionRangeSquared) {
            this.repulsionRangeSquared = repulsionRangeSquared;
            return this;
        }

        @Override
        public Builder<V> random(Random random) {
            this.random = random;
            return this;
        }

        @Override
        public BarnesHutSpringRepulsion<V> build() {
            return new BarnesHutSpringRepulsion(this);
        }
    }
}

