/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.cache;

import javax.swing.table.AbstractTableModel;
import tim.prune.I18nManager;
import tim.prune.function.cache.TileCacheModel;
import tim.prune.function.cache.TileSet;

public final class TileSetTableModel
extends AbstractTableModel {
    private final TileCacheModel _model;

    public TileSetTableModel(TileCacheModel tileCacheModel) {
        this._model = tileCacheModel;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return I18nManager.getText("dialog.diskcache.table.path");
            }
            case 1: {
                return I18nManager.getText("dialog.diskcache.table.usedby");
            }
            case 2: {
                return I18nManager.getText("dialog.diskcache.table.zoom");
            }
            case 3: {
                return I18nManager.getText("dialog.diskcache.table.tiles");
            }
            case 4: {
                return I18nManager.getText("dialog.diskcache.table.megabytes");
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        if (this._model == null) {
            return 0;
        }
        return this._model.getNumTileSets();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        TileSet tileSet;
        if (this._model != null && n2 >= 0 && n2 < this.getColumnCount() && (tileSet = this._model.getTileSet(n)) != null) {
            switch (n2) {
                case 0: {
                    return tileSet.getPath();
                }
                case 1: {
                    return tileSet.getUsedBy();
                }
                case 2: {
                    return tileSet.getRowInfo().getZoomRange();
                }
                case 3: {
                    return "" + tileSet.getRowInfo().getNumTiles();
                }
                case 4: {
                    return tileSet.getRowInfo().getTotalSize() / 1024L / 1024L + " MB";
                }
            }
        }
        return null;
    }
}

