/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.TimezoneHelper;
import tim.prune.function.filesleuth.ScanController;
import tim.prune.function.filesleuth.TrackFileFinder;
import tim.prune.function.filesleuth.TrackMatcher;
import tim.prune.function.filesleuth.data.DateRange;
import tim.prune.function.filesleuth.data.Filter;
import tim.prune.function.filesleuth.data.LocationFilter;
import tim.prune.function.filesleuth.data.TrackFile;
import tim.prune.function.filesleuth.data.TrackFileList;
import tim.prune.function.filesleuth.data.TrackFileStatus;
import tim.prune.function.filesleuth.gui.DateRangeEditor;
import tim.prune.function.filesleuth.gui.DateRangeUser;
import tim.prune.function.filesleuth.gui.LocationFilterEditor;
import tim.prune.function.filesleuth.gui.LocationFilterUser;
import tim.prune.function.filesleuth.gui.ResultsTableModel;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.StatusIcon;

public class FindFilesFunction
extends GenericFunction
implements DateRangeUser,
LocationFilterUser {
    private JDialog _dialog = null;
    private final File _startDir;
    private final boolean _subdirectories;
    private final TrackFileList _trackList = new TrackFileList();
    private ScanController _scanController = null;
    private ResultsTableModel _resultsModel = null;
    private TrackMatcher _matcher = null;
    private JProgressBar _progressBar;
    private JTextField _searchText = null;
    private JTextField _dateRangeField = null;
    private StatusIcon _dateValidStatus = null;
    private JTextField _locationFilterField = null;
    private JButton _editLocationButton = null;
    private JTable _resultsTable = null;
    private JButton _loadButton = null;
    private DateRangeEditor _dateRangeEditor = null;
    private LocationFilter _locationFilter = null;
    private LocationFilterEditor _locationFilterEditor = null;
    private JLabel _filePathLabel = null;

    public FindFilesFunction(App app, File file, boolean bl) {
        super(app);
        this._startDir = file;
        this._subdirectories = bl;
    }

    @Override
    public String getNameKey() {
        return "menu.file.findfile";
    }

    @Override
    public void begin() {
        this._dialog = new JDialog((Frame)this._parentFrame, this.getName());
        this._dialog.setLocationRelativeTo(this._parentFrame);
        this._dialog.getContentPane().add(this.makeContents());
        this._dialog.pack();
        this._trackList.addListener(n -> this.updateProgressBar());
        TimeZone timeZone = TimezoneHelper.getSelectedTimezone(this.getConfig());
        this._scanController = new ScanController(this._trackList, timeZone);
        this._progressBar.setIndeterminate(true);
        new TrackFileFinder(this._trackList, this._startDir, this._subdirectories).begin();
        this._dialog.setVisible(true);
    }

    private Component makeContents() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        jPanel.setLayout(new BorderLayout(0, 5));
        JPanel jPanel2 = new JPanel();
        double[] dArray = new double[]{0.2, 3.0, 0.2, 0.2};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        boolean[] blArray2 = blArray;
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2, dArray, blArray2);
        this._searchText = new JTextField(20);
        this._searchText.addActionListener(actionEvent -> this.filterChanged());
        JButton jButton = new JButton(I18nManager.getText("button.search"));
        jButton.addActionListener(actionEvent -> this.filterChanged());
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.findfile.searchtext")));
        guiGridLayout.add(this._searchText, true);
        guiGridLayout.add(new StatusIcon(this.getIconManager()));
        guiGridLayout.add(jButton);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.findfile.daterange")));
        this._dateRangeField = new JTextField(20);
        this._dateRangeField.addActionListener(actionEvent -> this.filterChanged());
        this._dateValidStatus = new StatusIcon(this.getIconManager());
        JButton jButton2 = new JButton(I18nManager.getText("button.edit"));
        jButton2.addActionListener(actionEvent -> this.editDateRange());
        guiGridLayout.add(this._dateRangeField, true);
        guiGridLayout.add(this._dateValidStatus);
        guiGridLayout.add(jButton2);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.findfile.locationfilter")));
        this._locationFilterField = new JTextField(20);
        this._locationFilterField.setEditable(false);
        this._locationFilterField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                FindFilesFunction.this.checkLocation();
            }
        });
        this._editLocationButton = new JButton(I18nManager.getText("button.edit"));
        this._editLocationButton.setEnabled(this._app.getTrackInfo().getTrack().getNumPoints() > 0);
        this._editLocationButton.addActionListener(actionEvent -> this.editLocationFilter());
        guiGridLayout.add(this._locationFilterField, true);
        guiGridLayout.add(new StatusIcon(this.getIconManager()));
        guiGridLayout.add(this._editLocationButton);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 5));
        this._progressBar = new JProgressBar(0, 10);
        this._progressBar.setPreferredSize(new Dimension(300, 30));
        this._progressBar.setValue(0);
        this._progressBar.setStringPainted(true);
        jPanel3.add((Component)this._progressBar, "North");
        this._resultsModel = new ResultsTableModel();
        this._matcher = new TrackMatcher(this._trackList, this._resultsModel);
        this._resultsTable = new JTable(this._resultsModel);
        this._resultsTable.getSelectionModel().addListSelectionListener(this::fileSelected);
        jPanel3.add((Component)new JScrollPane(this._resultsTable), "Center");
        this._filePathLabel = new JLabel(I18nManager.getText("dialog.findfile.filepath.none"));
        jPanel3.add((Component)this._filePathLabel, "South");
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        JButton jButton3 = new JButton(I18nManager.getText("button.cancel"));
        jButton3.addActionListener(actionEvent -> this.cancel());
        jPanel4.add(jButton3);
        JPanel jPanel5 = new JPanel();
        this._loadButton = new JButton(I18nManager.getText("button.load"));
        this._loadButton.setEnabled(false);
        this._loadButton.addActionListener(actionEvent -> this.loadSelectedTracks());
        jPanel5.add(this._loadButton);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)jPanel5, "West");
        jPanel6.add((Component)jPanel4, "East");
        jPanel.add((Component)jPanel6, "South");
        return jPanel;
    }

    private void checkLocation() {
        this._locationFilterField.setSelectionStart(0);
        this._locationFilterField.setSelectionEnd(0);
        boolean bl = this._app.getTrackInfo().getTrack().getNumPoints() > 0;
        this._editLocationButton.setEnabled(bl);
        if (!bl) {
            this.updateLocationFilter(null);
        }
    }

    private void editDateRange() {
        String string = this._dateRangeField.getText().trim();
        if (this._dateRangeEditor == null) {
            this._dateRangeEditor = new DateRangeEditor(this._dialog, this, this.getIconManager());
        }
        this._dateRangeEditor.show(string);
    }

    private void editLocationFilter() {
        if (this._app.getTrackInfo().getCurrentPoint() == null) {
            if (this._locationFilter == null) {
                this._app.showErrorMessage(this.getNameKey(), "dialog.locationfilter.nopointselected");
            }
            this.updateLocationFilter(null);
            return;
        }
        if (this._locationFilterEditor == null) {
            this._locationFilterEditor = new LocationFilterEditor(this._dialog, this);
        }
        this._locationFilterEditor.show(this._locationFilter, this._app.getTrackInfo().getCurrentPoint());
    }

    private void cancel() {
        if (this._scanController != null) {
            this._scanController.cancel();
        }
        this._dialog.dispose();
    }

    private void filterChanged() {
        this._matcher.setFilter(new Filter(this._searchText.getText(), this._dateRangeField.getText(), this._locationFilter));
        this.setDateValidStatus();
        this.updateProgressBar();
    }

    private void setDateValidStatus() {
        if (this._dateRangeField.getText().isEmpty()) {
            this._dateValidStatus.setStatusBlank();
        } else {
            DateRange dateRange = DateRange.parseString(this._dateRangeField.getText());
            if (dateRange.isValid()) {
                this._dateValidStatus.setStatusValid();
            } else {
                this._dateValidStatus.setStatusInvalid();
            }
        }
    }

    private void updateProgressBar() {
        if (this._trackList.isListComplete() && this._progressBar.isVisible()) {
            this._progressBar.setIndeterminate(false);
            List<TrackFile> list = this._trackList.getCurrentContents();
            this._progressBar.setMinimum(0);
            this._progressBar.setMaximum(list.size());
            int n = this.countScanned(list);
            this._progressBar.setValue(n);
            this._progressBar.setVisible(n != list.size());
        }
    }

    private int countScanned(List<TrackFile> list) {
        if (list == null) {
            return 0;
        }
        int n = 0;
        for (TrackFile trackFile : list) {
            if (trackFile.getStatus() != TrackFileStatus.COMPLETE) continue;
            ++n;
        }
        return n;
    }

    private void loadSelectedTracks() {
        int[] nArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        int[] nArray2 = nArray = this._resultsTable.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            arrayList.add(this._resultsModel.getFile(n3));
            ++n2;
        }
        if (!arrayList.isEmpty()) {
            this._app.loadDataFiles(arrayList);
        }
    }

    @Override
    public void updateDateRange(DateRange dateRange) {
        if (dateRange == null || dateRange.isEmpty()) {
            this._dateRangeField.setText("");
            this._dateValidStatus.setStatusBlank();
        } else {
            this._dateRangeField.setText(dateRange.toShortString());
            this._dateValidStatus.setStatusValid();
        }
        this.filterChanged();
    }

    @Override
    public void updateLocationFilter(LocationFilter locationFilter) {
        this._locationFilter = locationFilter;
        this._locationFilterField.setText(FindFilesFunction.makeLocationFilterText(locationFilter));
        this.filterChanged();
    }

    private static String makeLocationFilterText(LocationFilter locationFilter) {
        if (locationFilter == null || locationFilter.getPoint() == null || locationFilter.getDistanceValue() <= 0) {
            return "";
        }
        String string = locationFilter.getPointDescription();
        String string2 = String.valueOf(locationFilter.getDistanceValue()) + " " + I18nManager.getText(locationFilter.getDistanceUnit().getShortnameKey());
        return I18nManager.getText("dialog.locationfilter.describe", string2, string);
    }

    private void fileSelected(ListSelectionEvent listSelectionEvent) {
        int n = this._resultsTable.getSelectedRowCount();
        this._loadButton.setEnabled(n > 0);
        if (n == 0) {
            this._filePathLabel.setText(I18nManager.getText("dialog.findfile.filepath.none"));
        } else if (n == 1) {
            File file = this._resultsModel.getFile(this._resultsTable.getSelectedRow());
            this._filePathLabel.setText(I18nManager.getText("dialog.findfile.filepath.single", file.getAbsolutePath()));
        } else {
            int[] nArray;
            String string = this._resultsModel.getFile(this._resultsTable.getSelectedRow()).getAbsolutePath();
            int[] nArray2 = nArray = this._resultsTable.getSelectedRows();
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray2[n3];
                String string2 = this._resultsModel.getFile(n4).getAbsolutePath();
                while (!string2.startsWith(string)) {
                    string = new File(string).getParentFile().getAbsolutePath();
                }
                ++n3;
            }
            this._filePathLabel.setText(I18nManager.getText("dialog.findfile.filepath.multi", "" + n, string));
        }
    }
}

