/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import tim.prune.I18nManager;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;

public class PhotoTableEntry {
    private final Photo _photo;
    private final String _photoName;
    private final String _status;
    private boolean _save = true;

    public PhotoTableEntry(Photo photo) {
        this._photo = photo;
        this._photoName = this._photo == null ? null : this._photo.getName();
        this._status = this._photo == null ? null : PhotoTableEntry.getStatusString(photo.getOriginalStatus(), photo.getCurrentStatus());
    }

    private static String getStatusString(MediaObject.Status status, MediaObject.Status status2) {
        if (status != status2) {
            if (status == MediaObject.Status.NOT_CONNECTED) {
                return I18nManager.getText("dialog.saveexif.photostatus.connected");
            }
            if (status2 == MediaObject.Status.NOT_CONNECTED) {
                return I18nManager.getText("dialog.saveexif.photostatus.disconnected");
            }
            return I18nManager.getText("dialog.saveexif.photostatus.modified");
        }
        return null;
    }

    public Photo getPhoto() {
        return this._photo;
    }

    public String getName() {
        return this._photoName;
    }

    public String getStatus() {
        return this._status;
    }

    public void setSaveFlag(boolean bl) {
        this._save = bl;
    }

    public boolean getSaveFlag() {
        return this._save;
    }
}

