/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import org.gradle.api.problems.ProblemGroup;

public abstract class GradleCoreProblemGroup {
    private static final DefaultCompilationProblemGroup COMPILATION_PROBLEM_GROUP = new DefaultCompilationProblemGroup();
    private static final ProblemGroup DEPRECATION_PROBLEM_GROUP = ProblemGroup.create("deprecation", "Deprecation");
    private static final DefaultValidationProblemGroup VALIDATION_PROBLEM_GROUP = new DefaultValidationProblemGroup();
    private static final ProblemGroup PLUGIN_APPLICATION_PROBLEM_GROUP = ProblemGroup.create("plugin-application", "Plugin application");
    private static final ProblemGroup TASK_SELECTION_PROBLEM_GROUP = ProblemGroup.create("task-selection", "Task selection");
    private static final ProblemGroup VERSION_CATALOG_PROBLEM_GROUP = ProblemGroup.create("dependency-version-catalog", "Version catalog");
    private static final ProblemGroup VARIANT_RESOLUTION_PROBLEM_GROUP = ProblemGroup.create("dependency-variant-resolution", "Variant resolution");
    private static final ProblemGroup CONFIGURATION_USAGE_PROBLEM_GROUP = ProblemGroup.create("configuration-usage", "Configuration usage");
    private static final DaemonToolchainProblemGroup DAEMON_TOOLCHAIN_PROBLEM_GROUP = new DefaultDaemonToolchainProblemGroup();

    public static CompilationProblemGroup compilation() {
        return COMPILATION_PROBLEM_GROUP;
    }

    public static ProblemGroup deprecation() {
        return DEPRECATION_PROBLEM_GROUP;
    }

    public static ValidationProblemGroup validation() {
        return VALIDATION_PROBLEM_GROUP;
    }

    public static ProblemGroup pluginApplication() {
        return PLUGIN_APPLICATION_PROBLEM_GROUP;
    }

    public static ProblemGroup taskSelection() {
        return TASK_SELECTION_PROBLEM_GROUP;
    }

    public static ProblemGroup versionCatalog() {
        return VERSION_CATALOG_PROBLEM_GROUP;
    }

    public static ProblemGroup variantResolution() {
        return VARIANT_RESOLUTION_PROBLEM_GROUP;
    }

    public static ProblemGroup configurationUsage() {
        return CONFIGURATION_USAGE_PROBLEM_GROUP;
    }

    public static DaemonToolchainProblemGroup daemonToolchain() {
        return DAEMON_TOOLCHAIN_PROBLEM_GROUP;
    }

    private static class DefaultCompilationProblemGroup
    implements CompilationProblemGroup {
        private final ProblemGroup thisGroup = ProblemGroup.create("compilation", "Compilation");
        private final ProblemGroup java = ProblemGroup.create("java", "Java compilation", this.thisGroup);
        private final ProblemGroup groovy = ProblemGroup.create("groovy", "Groovy compilation", this.thisGroup);
        public ProblemGroup groovyDsl = ProblemGroup.create("groovy-dsl", "Groovy DSL script compilation", this.thisGroup);

        private DefaultCompilationProblemGroup() {
        }

        @Override
        public ProblemGroup thisGroup() {
            return this.thisGroup;
        }

        @Override
        public ProblemGroup java() {
            return this.java;
        }

        @Override
        public ProblemGroup groovy() {
            return this.groovy;
        }

        @Override
        public ProblemGroup groovyDsl() {
            return this.groovyDsl;
        }
    }

    private static class DefaultValidationProblemGroup
    implements ValidationProblemGroup {
        private final ProblemGroup thisGroup = ProblemGroup.create("validation", "Validation");
        private final ProblemGroup property = ProblemGroup.create("property-validation", "Gradle property validation", this.thisGroup);
        private final ProblemGroup type = ProblemGroup.create("type-validation", "Gradle type validation", this.thisGroup);

        private DefaultValidationProblemGroup() {
        }

        @Override
        public ProblemGroup thisGroup() {
            return this.thisGroup;
        }

        @Override
        public ProblemGroup property() {
            return this.property;
        }

        @Override
        public ProblemGroup type() {
            return this.type;
        }
    }

    public static interface DaemonToolchainProblemGroup {
        public ProblemGroup thisGroup();

        public ProblemGroup configurationGeneration();
    }

    private static class DefaultDaemonToolchainProblemGroup
    implements DaemonToolchainProblemGroup {
        private final ProblemGroup thisGroup = ProblemGroup.create("daemon-toolchain", "Daemon toolchain");
        private final ProblemGroup configurationGeneration = ProblemGroup.create("configuration-generation", "Gradle configuration generation", this.thisGroup);

        private DefaultDaemonToolchainProblemGroup() {
        }

        @Override
        public ProblemGroup thisGroup() {
            return this.thisGroup;
        }

        @Override
        public ProblemGroup configurationGeneration() {
            return this.configurationGeneration;
        }
    }

    public static interface ValidationProblemGroup {
        public ProblemGroup thisGroup();

        public ProblemGroup property();

        public ProblemGroup type();
    }

    public static interface CompilationProblemGroup {
        public ProblemGroup thisGroup();

        public ProblemGroup java();

        public ProblemGroup groovy();

        public ProblemGroup groovyDsl();
    }
}

