/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.base.plugins;

import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.testing.AbstractTestTask;

public abstract class TestingBasePlugin
implements Plugin<Project> {
    public static final String TEST_RESULTS_DIR_NAME = "test-results";
    public static final String TESTS_DIR_NAME = "tests";

    public void apply(final Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        project.getTasks().withType(AbstractTestTask.class, (Action)new Action<AbstractTestTask>(){

            public void execute(AbstractTestTask test) {
                test.getReports().getHtml().getOutputLocation().convention(TestingBasePlugin.this.getTestReportsDir(project, test));
                test.getReports().getJunitXml().getOutputLocation().convention(TestingBasePlugin.this.getTestResultsDir(project, test));
                test.getBinaryResultsDirectory().convention(TestingBasePlugin.this.getTestResultsDir(project, test).map((Transformer)new Transformer<Directory, Directory>(){

                    public Directory transform(Directory directory) {
                        return directory.dir("binary");
                    }
                }));
            }
        });
    }

    private Provider<Directory> getTestResultsDir(Project project, AbstractTestTask test) {
        return project.getLayout().getBuildDirectory().dir("test-results/" + test.getName());
    }

    private Provider<Directory> getTestReportsDir(Project project, AbstractTestTask test) {
        DirectoryProperty baseDirectory = ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getBaseDirectory();
        return baseDirectory.dir("tests/" + test.getName());
    }
}

