/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.TargetJdk;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.resources.TextResource;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.jspecify.annotations.Nullable;

public abstract class PmdExtension
extends CodeQualityExtension {
    private final Project project;
    private TargetJdk targetJdk;
    private TextResource ruleSetConfig;
    private ConfigurableFileCollection ruleSetFiles;
    private boolean consoleOutput;

    public PmdExtension(Project project) {
        this.project = project;
    }

    abstract ListProperty<String> getRuleSetsProperty();

    @ToBeReplacedByLazyProperty
    public List<String> getRuleSets() {
        return (List)this.getRuleSetsProperty().get();
    }

    public void setRuleSets(List<String> ruleSets) {
        this.getRuleSetsProperty().set(ruleSets);
    }

    public void ruleSets(String ... ruleSets) {
        this.getRuleSetsProperty().addAll(Arrays.asList(ruleSets));
    }

    @ToBeReplacedByLazyProperty
    public TargetJdk getTargetJdk() {
        return this.targetJdk;
    }

    public void setTargetJdk(TargetJdk targetJdk) {
        this.targetJdk = targetJdk;
    }

    public abstract Property<Integer> getMaxFailures();

    public void setTargetJdk(Object value) {
        this.targetJdk = TargetJdk.toVersion(value);
    }

    public abstract Property<Integer> getRulesMinimumPriority();

    @ToBeReplacedByLazyProperty
    public @Nullable TextResource getRuleSetConfig() {
        return this.ruleSetConfig;
    }

    public void setRuleSetConfig(@Nullable TextResource ruleSetConfig) {
        this.ruleSetConfig = ruleSetConfig;
    }

    @ToBeReplacedByLazyProperty
    public FileCollection getRuleSetFiles() {
        return this.ruleSetFiles;
    }

    public void setRuleSetFiles(FileCollection ruleSetFiles) {
        this.ruleSetFiles = this.project.getObjects().fileCollection().from(new Object[]{ruleSetFiles});
    }

    public void ruleSetFiles(Object ... ruleSetFiles) {
        this.ruleSetFiles.from(ruleSetFiles);
    }

    @ToBeReplacedByLazyProperty
    public boolean isConsoleOutput() {
        return this.consoleOutput;
    }

    public void setConsoleOutput(boolean consoleOutput) {
        this.consoleOutput = consoleOutput;
    }

    public abstract Property<Boolean> getIncrementalAnalysis();

    public abstract Property<Integer> getThreads();
}

