/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Time;

public class Deadline {
    private final long nanoseconds;

    public static Deadline fromMonotonicNanoseconds(long nanoseconds) {
        return new Deadline(nanoseconds);
    }

    public static Deadline fromDelay(Time time, long delay, TimeUnit timeUnit) {
        if (delay < 0L) {
            throw new RuntimeException("Negative delays are not allowed.");
        }
        long nowNs = time.nanoseconds();
        BigInteger deadlineNs = BigInteger.valueOf(nowNs).add(BigInteger.valueOf(timeUnit.toNanos(delay)));
        if (deadlineNs.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0) {
            return new Deadline(Long.MAX_VALUE);
        }
        return new Deadline(deadlineNs.longValue());
    }

    private Deadline(long nanoseconds) {
        this.nanoseconds = nanoseconds;
    }

    public long nanoseconds() {
        return this.nanoseconds;
    }

    public int hashCode() {
        return Objects.hash(this.nanoseconds);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Deadline other = (Deadline)o;
        return this.nanoseconds == other.nanoseconds;
    }
}

