/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.recording;

import io.quarkus.deployment.recording.RecordingAnnotationsProvider;
import io.quarkus.runtime.annotations.IgnoreProperty;
import io.quarkus.runtime.annotations.RecordableConstructor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.ServiceLoader;

final class RecordingAnnotationsUtil {
    private static final Class<? extends Annotation>[] IGNORED_PROPERTY_ANNOTATIONS;
    private static final Class<? extends Annotation>[] RECORDABLE_CONSTRUCTOR_ANNOTATIONS;

    private RecordingAnnotationsUtil() {
    }

    static boolean isIgnored(AccessibleObject object) {
        return RecordingAnnotationsUtil.annotationsMatch(object.getDeclaredAnnotations(), IGNORED_PROPERTY_ANNOTATIONS);
    }

    static boolean isRecordableConstructor(Constructor<?> ctor) {
        return RecordingAnnotationsUtil.annotationsMatch(ctor.getDeclaredAnnotations(), RECORDABLE_CONSTRUCTOR_ANNOTATIONS);
    }

    private static boolean annotationsMatch(Annotation[] declaredAnnotations, Class<? extends Annotation>[] typesToCheck) {
        for (Class<? extends Annotation> annotation : typesToCheck) {
            for (Annotation declaredAnnotation : declaredAnnotations) {
                if (!declaredAnnotation.annotationType().equals(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        HashSet<Class> ignoredPropertyAnnotations = new HashSet<Class>();
        ignoredPropertyAnnotations.add(IgnoreProperty.class);
        HashSet<Class> recordableConstructorAnnotations = new HashSet<Class>();
        recordableConstructorAnnotations.add(RecordableConstructor.class);
        for (RecordingAnnotationsProvider provider : ServiceLoader.load(RecordingAnnotationsProvider.class)) {
            Class<? extends Annotation> recordableConstructor;
            Class<? extends Annotation> ignoredProperty = provider.ignoredProperty();
            if (ignoredProperty != null) {
                ignoredPropertyAnnotations.add(ignoredProperty);
            }
            if ((recordableConstructor = provider.recordableConstructor()) == null) continue;
            recordableConstructorAnnotations.add(recordableConstructor);
        }
        IGNORED_PROPERTY_ANNOTATIONS = ignoredPropertyAnnotations.toArray(new Class[0]);
        RECORDABLE_CONSTRUCTOR_ANNOTATIONS = recordableConstructorAnnotations.toArray(new Class[0]);
    }
}

