/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.AbstractJsonArrayInsertFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerJsonArrayInsertFunction
extends AbstractJsonArrayInsertFunction {
    public SQLServerJsonArrayInsertFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        int index;
        String jsonPath = ((String)translator.getLiteralValue((Expression)arguments.get(1))).trim();
        int bracketEndIndex = jsonPath.lastIndexOf(93);
        int bracketStartIndex = jsonPath.lastIndexOf(91);
        if (jsonPath.isEmpty() || bracketEndIndex != jsonPath.length() - 1 || bracketStartIndex == -1) {
            throw new QueryException("JSON path does not end with an array index: " + jsonPath);
        }
        try {
            index = Integer.parseInt(jsonPath.substring(bracketStartIndex + 1, bracketEndIndex));
        }
        catch (NumberFormatException e) {
            throw new QueryException("JSON path does not point to a valid array index: " + jsonPath);
        }
        Expression json = (Expression)arguments.get(0);
        SqlAstNode value = arguments.get(2);
        sqlAppender.appendSql("(select case when left(json_query(x.d,x.p),1)='[' then ");
        sqlAppender.appendSql("json_modify(x.d,x.p,json_query((");
        sqlAppender.appendSql("select '['+string_agg(t.v,',') within group (order by t.k)+']' from (");
        sqlAppender.appendSql("select x.i k,x.v v union all ");
        sqlAppender.appendSql("select case when cast(t.[key] as int)>=x.i then cast(t.[key] as int)+1 ");
        sqlAppender.appendSql("else cast(t.[key] as int) end,");
        sqlAppender.appendSql("case t.type when 0 then 'null' when 1 then ");
        sqlAppender.appendSql("(select substring(a.v,6,len(a.v)-6) from (select t.value a for json path,without_array_wrapper) a(v))");
        sqlAppender.appendSql(" else t.value end from openjson(x.d,x.p) t) t))) ");
        sqlAppender.appendSql(" else x.d end ");
        sqlAppender.appendSql("from (values(");
        json.accept(translator);
        sqlAppender.append(',');
        sqlAppender.appendSingleQuoteEscapedString(jsonPath.substring(0, bracketStartIndex));
        sqlAppender.append(',');
        sqlAppender.appendSql(index);
        sqlAppender.append(',');
        value.accept(translator);
        sqlAppender.append(")) x(d,p,i,v))");
    }

    protected void renderArgument(SqlAppender sqlAppender, SqlAstNode arg, SqlAstTranslator<?> translator) {
        sqlAppender.appendSql("substring(json_modify('[]','append $',");
        arg.accept(translator);
        sqlAppender.appendSql("),2,len(json_modify('[]','append $',");
        arg.accept(translator);
        sqlAppender.appendSql("))-2)");
    }
}

