/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.InstanceIdentity;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.internal.util.collections.AbstractPagedArray;

public class InstanceIdentityMap<K extends InstanceIdentity, V>
extends AbstractPagedArray<Map.Entry<K, V>>
implements Map<K, V> {
    private int size;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(int instanceId, Object key) {
        return this.get(instanceId, key) != null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof InstanceIdentity) {
            InstanceIdentity instance = (InstanceIdentity)key;
            return this.containsKey(instance.$$_hibernate_getInstanceId(), instance);
        }
        throw new ClassCastException("Provided key does not support instance identity");
    }

    @Override
    public boolean containsValue(Object value) {
        for (V v : this.values()) {
            if (!Objects.equals(value, v)) continue;
            return true;
        }
        return false;
    }

    private boolean containsMapping(Object key, Object value) {
        if (key instanceof InstanceIdentity) {
            InstanceIdentity instance = (InstanceIdentity)key;
            return this.get(instance.$$_hibernate_getInstanceId(), instance) == value;
        }
        throw new ClassCastException("Provided key does not support instance identity");
    }

    public @Nullable V get(int instanceId, Object key) {
        if (instanceId <= 0) {
            return null;
        }
        Map.Entry entry = (Map.Entry)this.get(instanceId - 1);
        if (entry != null) {
            if (entry.getKey() == key) {
                return entry.getValue();
            }
            throw new ConcurrentModificationException("Found a different instance corresponding to instanceId [" + instanceId + "], this might indicate a concurrent access to this persistence context.");
        }
        return null;
    }

    @Override
    public @Nullable V get(Object key) {
        if (key instanceof InstanceIdentity) {
            InstanceIdentity instance = (InstanceIdentity)key;
            return this.get(instance.$$_hibernate_getInstanceId(), instance);
        }
        throw new ClassCastException("Provided key does not support instance identity");
    }

    @Override
    public @Nullable V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("This map does not support null keys");
        }
        int index = key.$$_hibernate_getInstanceId() - 1;
        if (index < 0) {
            throw new IllegalArgumentException("Instance ID must be a positive value");
        }
        Map.Entry old = this.set(index, new AbstractMap.SimpleImmutableEntry<K, V>(key, value));
        if (old == null) {
            ++this.size;
            return null;
        }
        return old.getValue();
    }

    public @Nullable V remove(int instanceId, Object key) {
        int pageOffset;
        Map.Entry entry;
        if (instanceId <= 0) {
            return null;
        }
        int index = instanceId - 1;
        AbstractPagedArray.Page page = this.getPage(index);
        if (page != null && (entry = (Map.Entry)page.set(pageOffset = InstanceIdentityMap.toPageOffset(index), null)) != null) {
            if (entry.getKey() == key) {
                --this.size;
                return entry.getValue();
            }
            throw new ConcurrentModificationException("Found a different instance corresponding to instanceId [" + instanceId + "], this might indicate a concurrent access to this persistence context.");
        }
        return null;
    }

    @Override
    public @Nullable V remove(Object key) {
        if (key instanceof InstanceIdentity) {
            InstanceIdentity instance = (InstanceIdentity)key;
            return this.remove(instance.$$_hibernate_getInstanceId(), (Object)instance);
        }
        throw new ClassCastException("Provided key does not support instance identity");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put((K)((InstanceIdentity)entry.getKey()), entry.getValue());
        }
    }

    @Override
    public @Nullable V putIfAbsent(K key, V value) {
        V v = this.get(key.$$_hibernate_getInstanceId(), key);
        if (v == null) {
            v = this.put(key, value);
        }
        return v;
    }

    @Override
    public void clear() {
        super.clear();
        this.size = 0;
    }

    @Override
    public @NonNull Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public @NonNull Collection<V> values() {
        return new Values();
    }

    @Override
    public @NonNull Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        for (AbstractPagedArray.Page page : this.elementPages) {
            if (page == null) continue;
            for (int j = 0; j <= page.lastNotEmptyOffset(); ++j) {
                Map.Entry entry = (Map.Entry)page.get(j);
                if (entry == null) continue;
                action.accept(entry.getKey(), entry.getValue());
            }
        }
    }

    public Map.Entry<K, V>[] toArray() {
        return this.entrySet().toArray(new Map.Entry[0]);
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public @NonNull Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return InstanceIdentityMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return InstanceIdentityMap.this.containsKey(o);
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public @NonNull Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return InstanceIdentityMap.this.size();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public @NonNull Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return InstanceIdentityMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry;
            return o instanceof Map.Entry && InstanceIdentityMap.this.containsMapping((entry = (Map.Entry)o).getKey(), entry.getValue());
        }

        @Override
        public @NonNull Object @NonNull [] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        @AllowReflection
        public <T> @NonNull T @NonNull [] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            int i = 0;
            for (AbstractPagedArray.Page page : InstanceIdentityMap.this.elementPages) {
                if (page == null) continue;
                for (int j = 0; j <= page.lastNotEmptyOffset(); ++j) {
                    Map.Entry entry = (Map.Entry)page.get(j);
                    if (entry == null) continue;
                    a[i++] = entry;
                }
            }
            if (i < size) {
                throw new ConcurrentModificationException();
            }
            if (i < a.length) {
                a[i] = null;
            }
            return a;
        }
    }

    private class EntryIterator
    extends AbstractPagedArray.PagedArrayIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return new Entry(this.nextIndex());
        }

        private class Entry
        implements Map.Entry<K, V> {
            private final int index;

            private Entry(int index) {
                this.index = index;
            }

            @Override
            public K getKey() {
                return (InstanceIdentity)((Map.Entry)InstanceIdentityMap.this.get(this.index)).getKey();
            }

            @Override
            public V getValue() {
                return ((Map.Entry)InstanceIdentityMap.this.get(this.index)).getValue();
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object o) {
                Map.Entry e;
                return o instanceof Map.Entry && Objects.equals((e = (Map.Entry)o).getKey(), this.getKey()) && Objects.equals(e.getValue(), this.getValue());
            }

            @Override
            public int hashCode() {
                return this.getKey().hashCode() ^ Objects.hashCode(this.getValue());
            }

            public String toString() {
                return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
            }
        }
    }

    private class ValueIterator
    extends AbstractPagedArray.PagedArrayIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return ((Map.Entry)InstanceIdentityMap.this.get(this.nextIndex())).getValue();
        }
    }

    private class KeyIterator
    extends AbstractPagedArray.PagedArrayIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return (InstanceIdentity)((Map.Entry)InstanceIdentityMap.this.get(this.nextIndex())).getKey();
        }
    }
}

