/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;

public final class SetFunction<K, V>
implements ListBucketBaseFunction<K, V, Boolean> {
    public static final AdvancedExternalizer<SetFunction> EXTERNALIZER = new Externalizer();
    private final long index;
    private final V value;

    public SetFunction(long index, V value) {
        this.index = index;
        this.value = value;
    }

    public Boolean apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            ListBucket<V> newBucket = ((ListBucket)existing.get()).set(this.index, this.value);
            if (newBucket != null) {
                entryView.set(newBucket, new MetaParam.Writable[0]);
                return true;
            }
            throw new CacheException((Throwable)new IndexOutOfBoundsException("Index is out of range"));
        }
        return false;
    }

    private static class Externalizer
    implements AdvancedExternalizer<SetFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends SetFunction>> getTypeClasses() {
            return Collections.singleton(SetFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SET_FUNCTION;
        }

        public void writeObject(ObjectOutput output, SetFunction object) throws IOException {
            output.writeLong(object.index);
            output.writeObject(object.value);
        }

        public SetFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new SetFunction(input.readLong(), input.readObject());
        }
    }
}

