/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.authentication.requiredactions.UpdateEmail;
import org.keycloak.common.Profile;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.representations.userprofile.config.UPAttribute;
import org.keycloak.representations.userprofile.config.UPAttributePermissions;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.DeclarativeUserProfileProvider;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.UserProfileProviderFactory;
import org.keycloak.userprofile.config.UPConfigUtils;
import org.keycloak.userprofile.validator.BlankAttributeValidator;
import org.keycloak.utils.StringUtil;
import org.keycloak.validate.ValidatorConfig;

public class DeclarativeUserProfileProviderFactory
implements UserProfileProviderFactory,
AmphibianProviderFactory<UserProfileProvider> {
    public static final String CONFIG_ADMIN_READ_ONLY_ATTRIBUTES = "admin-read-only-attributes";
    public static final String CONFIG_READ_ONLY_ATTRIBUTES = "read-only-attributes";
    public static final String MAX_EMAIL_LOCAL_PART_LENGTH = "max-email-local-part-length";
    public static final String ID = "declarative-user-profile";
    public static final int PROVIDER_PRIORITY = 1;
    private static final String[] DEFAULT_READ_ONLY_ATTRIBUTES = new String[]{"KERBEROS_PRINCIPAL", "LDAP_ID", "LDAP_ENTRY_DN", "CREATED_TIMESTAMP", "createTimestamp", "modifyTimestamp", "userCertificate", "saml.persistent.name.id.for.*", "ENABLED", "EMAIL_VERIFIED", "disabledReason", "kc.email.pending"};
    private static final String[] DEFAULT_ADMIN_READ_ONLY_ATTRIBUTES = new String[]{"KERBEROS_PRINCIPAL", "LDAP_ID", "LDAP_ENTRY_DN", "CREATED_TIMESTAMP", "createTimestamp", "modifyTimestamp"};
    private static final Pattern readOnlyAttributesPattern = DeclarativeUserProfileProviderFactory.getRegexPatternString(DEFAULT_READ_ONLY_ATTRIBUTES);
    private static final Pattern adminReadOnlyAttributesPattern = DeclarativeUserProfileProviderFactory.getRegexPatternString(DEFAULT_ADMIN_READ_ONLY_ATTRIBUTES);
    private static volatile UPConfig PARSED_DEFAULT_RAW_CONFIG;
    private final Map<UserProfileContext, UserProfileMetadata> contextualMetadataRegistry = new HashMap<UserProfileContext, UserProfileMetadata>();

    public static void setDefaultConfig(UPConfig defaultConfig) {
        if (PARSED_DEFAULT_RAW_CONFIG == null) {
            PARSED_DEFAULT_RAW_CONFIG = defaultConfig;
        }
    }

    private static boolean editUsernameCondition(AttributeContext c) {
        KeycloakSession session = c.getSession();
        KeycloakContext context = session.getContext();
        RealmModel realm = context.getRealm();
        if (UserProfileContext.REGISTRATION.equals((Object)c.getContext()) || UserProfileContext.IDP_REVIEW.equals((Object)c.getContext()) || DeclarativeUserProfileProviderFactory.isNewUser(c)) {
            return !realm.isRegistrationEmailAsUsername();
        }
        if (realm.isRegistrationEmailAsUsername()) {
            return false;
        }
        return realm.isEditUsernameAllowed();
    }

    private static boolean readUsernameCondition(AttributeContext c) {
        KeycloakSession session = c.getSession();
        KeycloakContext context = session.getContext();
        RealmModel realm = context.getRealm();
        switch (c.getContext()) {
            case REGISTRATION: 
            case IDP_REVIEW: {
                return !realm.isRegistrationEmailAsUsername();
            }
            case UPDATE_PROFILE: {
                if (realm.isRegistrationEmailAsUsername()) {
                    return false;
                }
                return realm.isEditUsernameAllowed();
            }
            case UPDATE_EMAIL: {
                return false;
            }
        }
        return true;
    }

    private static boolean editEmailCondition(AttributeContext c) {
        RealmModel realm = c.getSession().getContext().getRealm();
        if (UserProfileContext.REGISTRATION.equals((Object)c.getContext()) || UserProfileContext.USER_API.equals((Object)c.getContext())) {
            return true;
        }
        if (UpdateEmail.isEnabled(realm)) {
            if (UserProfileContext.UPDATE_PROFILE.equals((Object)c.getContext())) {
                UserModel user = c.getUser();
                if (!DeclarativeUserProfileProviderFactory.isNewUser(c)) {
                    if (StringUtil.isBlank((String)user.getEmail())) {
                        return true;
                    }
                    List values = (List)c.getAttribute().getValue();
                    if (values == null || values.isEmpty()) {
                        return false;
                    }
                }
            }
            return !UserProfileContext.UPDATE_PROFILE.equals((Object)c.getContext()) && !UserProfileContext.ACCOUNT.equals((Object)c.getContext());
        }
        return DeclarativeUserProfileProviderFactory.isNewUser(c) || !realm.isRegistrationEmailAsUsername() || realm.isEditUsernameAllowed();
    }

    private static boolean readEmailCondition(AttributeContext c) {
        RealmModel realm;
        UserProfileContext context = c.getContext();
        if (UserProfileContext.REGISTRATION.equals((Object)context) || UserProfileContext.USER_API.equals((Object)c.getContext())) {
            return true;
        }
        KeycloakSession session = c.getSession();
        if (UpdateEmail.isEnabled(session.getContext().getRealm())) {
            List value;
            if (UserProfileContext.UPDATE_PROFILE.equals((Object)c.getContext()) && (value = (List)c.getAttribute().getValue()).isEmpty() && !c.getMetadata().isReadOnly(c)) {
                return true;
            }
            return !UserProfileContext.UPDATE_PROFILE.equals((Object)context);
        }
        if (UserProfileContext.UPDATE_PROFILE.equals((Object)context) && (realm = session.getContext().getRealm()).isRegistrationEmailAsUsername()) {
            return realm.isEditUsernameAllowed();
        }
        return true;
    }

    private static boolean isInternationalizationEnabled(AttributeContext context) {
        RealmModel realm = context.getSession().getContext().getRealm();
        return realm.isInternationalizationEnabled();
    }

    private static boolean isTermAndConditionsEnabled(AttributeContext context) {
        RealmModel realm = context.getSession().getContext().getRealm();
        RequiredActionProviderModel tacModel = realm.getRequiredActionProviderByAlias(UserModel.RequiredAction.TERMS_AND_CONDITIONS.name());
        return tacModel != null && tacModel.isEnabled();
    }

    private static boolean isNewUser(AttributeContext c) {
        return c.getUser() == null;
    }

    public static Pattern getRegexPatternString(String[] builtinReadOnlyAttributes) {
        if (builtinReadOnlyAttributes != null) {
            ArrayList<String> readOnlyAttributes = new ArrayList<String>(Arrays.asList(builtinReadOnlyAttributes));
            Object regexStr = readOnlyAttributes.stream().map(configAttrName -> configAttrName.endsWith("*") ? "^" + Pattern.quote(configAttrName.substring(0, configAttrName.length() - 1)) + ".*$" : "^" + Pattern.quote(configAttrName) + "$").collect(Collectors.joining("|"));
            regexStr = "(?i:" + (String)regexStr + ")";
            return Pattern.compile((String)regexStr);
        }
        return null;
    }

    public void init(Config.Scope config) {
        this.initDefaultConfiguration(config);
        this.contextualMetadataRegistry.clear();
        Pattern pattern = DeclarativeUserProfileProviderFactory.getRegexPatternString(config.getArray(CONFIG_READ_ONLY_ATTRIBUTES));
        AttributeValidatorMetadata readOnlyValidator = null;
        if (pattern != null) {
            readOnlyValidator = this.createReadOnlyAttributeUnchangedValidator(pattern);
        }
        this.addContextualProfileMetadata(this.configureUserProfile(this.createBrokeringProfile(readOnlyValidator)));
        this.addContextualProfileMetadata(this.configureUserProfile(this.createAccountProfile(UserProfileContext.ACCOUNT, readOnlyValidator)));
        this.addContextualProfileMetadata(this.configureUserProfile(this.createDefaultProfile(UserProfileContext.UPDATE_PROFILE, readOnlyValidator)));
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL)) {
            this.addContextualProfileMetadata(this.configureUserProfile(this.createDefaultProfile(UserProfileContext.UPDATE_EMAIL, readOnlyValidator)));
        }
        this.addContextualProfileMetadata(this.configureUserProfile(this.createRegistrationUserCreationProfile(readOnlyValidator)));
        this.addContextualProfileMetadata(this.configureUserProfile(this.createUserResourceValidation(config)));
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(CONFIG_READ_ONLY_ATTRIBUTES).type("MultivaluedString").helpText("Array of regular expressions to identify fields that should be treated read-only so users can't change them.").add().property().name(CONFIG_ADMIN_READ_ONLY_ATTRIBUTES).type("MultivaluedString").helpText("Array of regular expressions to identify fields that should be treated read-only so administrators can't change them.").add().property().name(MAX_EMAIL_LOCAL_PART_LENGTH).type("String").helpText("To set user profile max email local part length").add().build();
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name("kc.user.profile.config").type("String").add().build();
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        String upConfigJson;
        String string = upConfigJson = model == null ? null : model.get("kc.user.profile.config");
        if (!ObjectUtil.isBlank((CharSequence)upConfigJson)) {
            try {
                UPConfig upc = UPConfigUtils.parseConfig(upConfigJson);
                List<String> errors = UPConfigUtils.validate(session, upc);
                if (!errors.isEmpty()) {
                    throw new ComponentValidationException(errors.toString(), new Object[0]);
                }
            }
            catch (IOException e) {
                throw new ComponentValidationException(e.getMessage(), (Throwable)e);
            }
        }
        if (model != null) {
            model.removeNote("kc.user.profile.metadata");
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return ID;
    }

    public int order() {
        return 1;
    }

    public String getHelpText() {
        return null;
    }

    public void close() {
    }

    public DeclarativeUserProfileProvider create(KeycloakSession session) {
        return new DeclarativeUserProfileProvider(session, this);
    }

    protected UserProfileMetadata configureUserProfile(UserProfileMetadata metadata) {
        return new DeclarativeUserProfileProvider(null, this).decorateUserProfileForCache(metadata, PARSED_DEFAULT_RAW_CONFIG);
    }

    private AttributeValidatorMetadata createReadOnlyAttributeUnchangedValidator(Pattern pattern) {
        return new AttributeValidatorMetadata("up-readonly-attribute-unchanged", ValidatorConfig.builder().config("pattern", (Object)pattern).build());
    }

    private void addContextualProfileMetadata(UserProfileMetadata metadata) {
        if (this.contextualMetadataRegistry.putIfAbsent(metadata.getContext(), metadata) != null) {
            throw new IllegalStateException("Multiple profile metadata found for context " + String.valueOf(metadata.getContext()));
        }
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            for (AttributeMetadata attribute : metadata.getAttributes()) {
                String name = attribute.getName();
                if (!"email".equals(name)) continue;
                attribute.addValidators(List.of(new AttributeValidatorMetadata("organization-member-validator")));
            }
        }
    }

    private UserProfileMetadata createBrokeringProfile(AttributeValidatorMetadata readOnlyValidator) {
        UserProfileMetadata metadata = new UserProfileMetadata(UserProfileContext.IDP_REVIEW);
        metadata.addAttribute("username", -2, DeclarativeUserProfileProviderFactory::editUsernameCondition, DeclarativeUserProfileProviderFactory::readUsernameCondition, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-brokering-federated-username-has-value")}).setAttributeDisplayName("${username}");
        metadata.addAttribute("email", -1, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-blank-attribute-value", BlankAttributeValidator.createConfig("missingEmailMessage", true))}).setAttributeDisplayName("${email}");
        ArrayList<AttributeValidatorMetadata> readonlyValidators = new ArrayList<AttributeValidatorMetadata>();
        readonlyValidators.add(this.createReadOnlyAttributeUnchangedValidator(readOnlyAttributesPattern));
        if (readOnlyValidator != null) {
            readonlyValidators.add(readOnlyValidator);
        }
        metadata.addAttribute("kc.read.only", 1000, readonlyValidators);
        return metadata;
    }

    private UserProfileMetadata createRegistrationUserCreationProfile(AttributeValidatorMetadata readOnlyValidator) {
        UserProfileMetadata metadata = this.createDefaultProfile(UserProfileContext.REGISTRATION, readOnlyValidator);
        ((AttributeMetadata)metadata.getAttribute("username").get(0)).addValidators(Arrays.asList(new AttributeValidatorMetadata("up-registration-email-as-username-username-value"), new AttributeValidatorMetadata("up-registration-username-exists"), new AttributeValidatorMetadata("up-username-has-value")));
        ((AttributeMetadata)metadata.getAttribute("email").get(0)).addValidators(Collections.singletonList(new AttributeValidatorMetadata("up-registration-email-as-username-email-value")));
        metadata.addAttribute("locale", -1, DeclarativeUserProfileProviderFactory::isInternationalizationEnabled, DeclarativeUserProfileProviderFactory::isInternationalizationEnabled, new AttributeValidatorMetadata[0]).setRequired(AttributeMetadata.ALWAYS_FALSE);
        return metadata;
    }

    private UserProfileMetadata createDefaultProfile(UserProfileContext context, AttributeValidatorMetadata readOnlyValidator) {
        UserProfileMetadata metadata = new UserProfileMetadata(context);
        metadata.addAttribute("username", -2, DeclarativeUserProfileProviderFactory::editUsernameCondition, DeclarativeUserProfileProviderFactory::readUsernameCondition, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-username-has-value"), new AttributeValidatorMetadata("up-duplicate-username"), new AttributeValidatorMetadata("up-username-mutation")}).setAttributeDisplayName("${username}");
        metadata.addAttribute("email", -1, DeclarativeUserProfileProviderFactory::editEmailCondition, DeclarativeUserProfileProviderFactory::readEmailCondition, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-blank-attribute-value", BlankAttributeValidator.createConfig("missingEmailMessage", false)), new AttributeValidatorMetadata("up-duplicate-email"), new AttributeValidatorMetadata("up-email-exists-as-username"), new AttributeValidatorMetadata("email", ValidatorConfig.builder().config("ignore.empty.value", (Object)true).build())}).setAttributeDisplayName("${email}").setAnnotationDecorator(DeclarativeUserProfileProviderFactory::getEmailAnnotationDecorator);
        ArrayList<AttributeValidatorMetadata> readonlyValidators = new ArrayList<AttributeValidatorMetadata>();
        readonlyValidators.add(this.createReadOnlyAttributeUnchangedValidator(readOnlyAttributesPattern));
        if (readOnlyValidator != null) {
            readonlyValidators.add(readOnlyValidator);
        }
        metadata.addAttribute("kc.read.only", 1000, readonlyValidators);
        return metadata;
    }

    private UserProfileMetadata createUserResourceValidation(Config.Scope config) {
        Pattern p = DeclarativeUserProfileProviderFactory.getRegexPatternString(config.getArray(CONFIG_ADMIN_READ_ONLY_ATTRIBUTES));
        UserProfileMetadata metadata = new UserProfileMetadata(UserProfileContext.USER_API);
        metadata.addAttribute("username", -2, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-username-has-value"), new AttributeValidatorMetadata("up-duplicate-username")}).addWriteCondition(DeclarativeUserProfileProviderFactory::editUsernameCondition);
        metadata.addAttribute("email", -1, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-duplicate-email"), new AttributeValidatorMetadata("up-email-exists-as-username"), new AttributeValidatorMetadata("email", ValidatorConfig.builder().config("ignore.empty.value", (Object)true).build())}).addWriteCondition(DeclarativeUserProfileProviderFactory::editEmailCondition);
        ArrayList<AttributeValidatorMetadata> readonlyValidators = new ArrayList<AttributeValidatorMetadata>();
        if (p != null) {
            readonlyValidators.add(this.createReadOnlyAttributeUnchangedValidator(p));
        }
        readonlyValidators.add(this.createReadOnlyAttributeUnchangedValidator(adminReadOnlyAttributesPattern));
        metadata.addAttribute("kc.read.only", 1000, readonlyValidators);
        metadata.addAttribute("locale", -1, DeclarativeUserProfileProviderFactory::isInternationalizationEnabled, DeclarativeUserProfileProviderFactory::isInternationalizationEnabled, new AttributeValidatorMetadata[0]).setRequired(AttributeMetadata.ALWAYS_FALSE);
        metadata.addAttribute("kc.email.pending", -1, this::isUpdateEmailFeatureEnabled, this::isUpdateEmailFeatureEnabled, new AttributeValidatorMetadata[0]).setAttributeDisplayName("${emailPendingVerification}").setRequired(AttributeMetadata.ALWAYS_FALSE);
        metadata.addAttribute("terms_and_conditions", -1, AttributeMetadata.ALWAYS_FALSE, DeclarativeUserProfileProviderFactory::isTermAndConditionsEnabled, new AttributeValidatorMetadata[0]).setAttributeDisplayName("${termsAndConditionsUserAttribute}").setRequired(AttributeMetadata.ALWAYS_FALSE);
        return metadata;
    }

    private UserProfileMetadata createAccountProfile(UserProfileContext context, AttributeValidatorMetadata readOnlyValidator) {
        UserProfileMetadata defaultProfile = this.createDefaultProfile(context, readOnlyValidator);
        defaultProfile.addAttribute("locale", -1, DeclarativeUserProfileProviderFactory::isInternationalizationEnabled, DeclarativeUserProfileProviderFactory::isInternationalizationEnabled, new AttributeValidatorMetadata[0]).setRequired(AttributeMetadata.ALWAYS_FALSE);
        return defaultProfile;
    }

    protected UPConfig getParsedDefaultRawConfig() {
        return PARSED_DEFAULT_RAW_CONFIG;
    }

    protected Map<UserProfileContext, UserProfileMetadata> getContextualMetadataRegistry() {
        return this.contextualMetadataRegistry;
    }

    private void initDefaultConfiguration(Config.Scope config) {
        UPConfig defaultConfig = Optional.ofNullable(config.get("configFile")).map(x$0 -> Paths.get(x$0, new String[0])).map(UPConfigUtils::parseConfig).orElse(PARSED_DEFAULT_RAW_CONFIG);
        if (defaultConfig == null) {
            defaultConfig = UPConfigUtils.parseSystemDefaultConfig();
        }
        PARSED_DEFAULT_RAW_CONFIG = null;
        DeclarativeUserProfileProviderFactory.setDefaultConfig(defaultConfig);
    }

    private static Map<String, Object> getEmailAnnotationDecorator(AttributeContext c) {
        AttributeMetadata m = c.getMetadata();
        Map<String, Object> rawAnnotations = Optional.ofNullable(m.getAnnotations()).orElse(Map.of());
        KeycloakSession session = c.getSession();
        KeycloakContext context = session.getContext();
        if (UpdateEmail.isEnabled(context.getRealm())) {
            UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
            UPConfig upConfig = provider.getConfiguration();
            UPAttribute attribute = upConfig.getAttribute("email");
            UPAttributePermissions permissions = attribute.getPermissions();
            if (permissions == null) {
                return rawAnnotations;
            }
            Set writePermissions = permissions.getEdit();
            boolean isWritable = writePermissions.contains("user");
            RealmModel realm = context.getRealm();
            if (realm.isRegistrationEmailAsUsername() && !realm.isEditUsernameAllowed() || !isWritable) {
                return rawAnnotations;
            }
            HashMap<String, Object> annotations = new HashMap<String, Object>(rawAnnotations);
            annotations.put("kc.required.action.supported", isWritable);
            return annotations;
        }
        return rawAnnotations;
    }

    private boolean isUpdateEmailFeatureEnabled(AttributeContext context) {
        Map.Entry attribute = context.getAttribute();
        if (((List)attribute.getValue()).isEmpty()) {
            return false;
        }
        KeycloakSession session = context.getSession();
        KeycloakContext context1 = session.getContext();
        RealmModel realm = context1.getRealm();
        return UpdateEmail.isEnabled(realm);
    }
}

