/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.RemoteStoreTranslogStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TranslogStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, TranslogStats> {
    private final long earliestLastModifiedAge;
    private final int operations;
    @Nullable
    private final RemoteStoreTranslogStats remoteStore;
    @Nullable
    private final String size;
    private final long sizeInBytes;
    private final int uncommittedOperations;
    @Nullable
    private final String uncommittedSize;
    private final long uncommittedSizeInBytes;
    public static final JsonpDeserializer<TranslogStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TranslogStats::setupTranslogStatsDeserializer);

    private TranslogStats(Builder builder) {
        this.earliestLastModifiedAge = ApiTypeHelper.requireNonNull(builder.earliestLastModifiedAge, this, "earliestLastModifiedAge");
        this.operations = ApiTypeHelper.requireNonNull(builder.operations, this, "operations");
        this.remoteStore = builder.remoteStore;
        this.size = builder.size;
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, this, "sizeInBytes");
        this.uncommittedOperations = ApiTypeHelper.requireNonNull(builder.uncommittedOperations, this, "uncommittedOperations");
        this.uncommittedSize = builder.uncommittedSize;
        this.uncommittedSizeInBytes = ApiTypeHelper.requireNonNull(builder.uncommittedSizeInBytes, this, "uncommittedSizeInBytes");
    }

    public static TranslogStats of(Function<Builder, ObjectBuilder<TranslogStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long earliestLastModifiedAge() {
        return this.earliestLastModifiedAge;
    }

    public final int operations() {
        return this.operations;
    }

    @Nullable
    public final RemoteStoreTranslogStats remoteStore() {
        return this.remoteStore;
    }

    @Nullable
    public final String size() {
        return this.size;
    }

    public final long sizeInBytes() {
        return this.sizeInBytes;
    }

    public final int uncommittedOperations() {
        return this.uncommittedOperations;
    }

    @Nullable
    public final String uncommittedSize() {
        return this.uncommittedSize;
    }

    public final long uncommittedSizeInBytes() {
        return this.uncommittedSizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("earliest_last_modified_age");
        generator.write(this.earliestLastModifiedAge);
        generator.writeKey("operations");
        generator.write(this.operations);
        if (this.remoteStore != null) {
            generator.writeKey("remote_store");
            this.remoteStore.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
        generator.writeKey("uncommitted_operations");
        generator.write(this.uncommittedOperations);
        if (this.uncommittedSize != null) {
            generator.writeKey("uncommitted_size");
            generator.write(this.uncommittedSize);
        }
        generator.writeKey("uncommitted_size_in_bytes");
        generator.write(this.uncommittedSizeInBytes);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTranslogStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::earliestLastModifiedAge, JsonpDeserializer.longDeserializer(), "earliest_last_modified_age");
        op.add(Builder::operations, JsonpDeserializer.integerDeserializer(), "operations");
        op.add(Builder::remoteStore, RemoteStoreTranslogStats._DESERIALIZER, "remote_store");
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size");
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
        op.add(Builder::uncommittedOperations, JsonpDeserializer.integerDeserializer(), "uncommitted_operations");
        op.add(Builder::uncommittedSize, JsonpDeserializer.stringDeserializer(), "uncommitted_size");
        op.add(Builder::uncommittedSizeInBytes, JsonpDeserializer.longDeserializer(), "uncommitted_size_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Long.hashCode(this.earliestLastModifiedAge);
        result = 31 * result + Integer.hashCode(this.operations);
        result = 31 * result + Objects.hashCode(this.remoteStore);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Long.hashCode(this.sizeInBytes);
        result = 31 * result + Integer.hashCode(this.uncommittedOperations);
        result = 31 * result + Objects.hashCode(this.uncommittedSize);
        result = 31 * result + Long.hashCode(this.uncommittedSizeInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslogStats other = (TranslogStats)o;
        return this.earliestLastModifiedAge == other.earliestLastModifiedAge && this.operations == other.operations && Objects.equals(this.remoteStore, other.remoteStore) && Objects.equals(this.size, other.size) && this.sizeInBytes == other.sizeInBytes && this.uncommittedOperations == other.uncommittedOperations && Objects.equals(this.uncommittedSize, other.uncommittedSize) && this.uncommittedSizeInBytes == other.uncommittedSizeInBytes;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, TranslogStats> {
        private Long earliestLastModifiedAge;
        private Integer operations;
        @Nullable
        private RemoteStoreTranslogStats remoteStore;
        @Nullable
        private String size;
        private Long sizeInBytes;
        private Integer uncommittedOperations;
        @Nullable
        private String uncommittedSize;
        private Long uncommittedSizeInBytes;

        public Builder() {
        }

        private Builder(TranslogStats o) {
            this.earliestLastModifiedAge = o.earliestLastModifiedAge;
            this.operations = o.operations;
            this.remoteStore = o.remoteStore;
            this.size = o.size;
            this.sizeInBytes = o.sizeInBytes;
            this.uncommittedOperations = o.uncommittedOperations;
            this.uncommittedSize = o.uncommittedSize;
            this.uncommittedSizeInBytes = o.uncommittedSizeInBytes;
        }

        private Builder(Builder o) {
            this.earliestLastModifiedAge = o.earliestLastModifiedAge;
            this.operations = o.operations;
            this.remoteStore = o.remoteStore;
            this.size = o.size;
            this.sizeInBytes = o.sizeInBytes;
            this.uncommittedOperations = o.uncommittedOperations;
            this.uncommittedSize = o.uncommittedSize;
            this.uncommittedSizeInBytes = o.uncommittedSizeInBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder earliestLastModifiedAge(long value) {
            this.earliestLastModifiedAge = value;
            return this;
        }

        @Nonnull
        public final Builder operations(int value) {
            this.operations = value;
            return this;
        }

        @Nonnull
        public final Builder remoteStore(@Nullable RemoteStoreTranslogStats value) {
            this.remoteStore = value;
            return this;
        }

        @Nonnull
        public final Builder remoteStore(Function<RemoteStoreTranslogStats.Builder, ObjectBuilder<RemoteStoreTranslogStats>> fn) {
            return this.remoteStore(fn.apply(new RemoteStoreTranslogStats.Builder()).build());
        }

        @Nonnull
        public final Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder uncommittedOperations(int value) {
            this.uncommittedOperations = value;
            return this;
        }

        @Nonnull
        public final Builder uncommittedSize(@Nullable String value) {
            this.uncommittedSize = value;
            return this;
        }

        @Nonnull
        public final Builder uncommittedSizeInBytes(long value) {
            this.uncommittedSizeInBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public TranslogStats build() {
            this._checkSingleUse();
            return new TranslogStats(this);
        }
    }
}

