/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ml.GuardrailsInputOutput;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Guardrails
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Guardrails> {
    @Nullable
    private final String indexName;
    @Nullable
    private final GuardrailsInputOutput inputGuardrail;
    @Nullable
    private final String modelId;
    @Nullable
    private final GuardrailsInputOutput outputGuardrail;
    @Nonnull
    private final Map<String, JsonData> regex;
    @Nullable
    private final String responseFilter;
    @Nullable
    private final String responseValidationRegex;
    @Nonnull
    private final List<String> sourceFields;
    @Nonnull
    private final List<String> stopWords;
    @Nullable
    private final String type;
    public static final JsonpDeserializer<Guardrails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Guardrails::setupGuardrailsDeserializer);

    private Guardrails(Builder builder) {
        this.indexName = builder.indexName;
        this.inputGuardrail = builder.inputGuardrail;
        this.modelId = builder.modelId;
        this.outputGuardrail = builder.outputGuardrail;
        this.regex = ApiTypeHelper.unmodifiable(builder.regex);
        this.responseFilter = builder.responseFilter;
        this.responseValidationRegex = builder.responseValidationRegex;
        this.sourceFields = ApiTypeHelper.unmodifiable(builder.sourceFields);
        this.stopWords = ApiTypeHelper.unmodifiable(builder.stopWords);
        this.type = builder.type;
    }

    public static Guardrails of(Function<Builder, ObjectBuilder<Guardrails>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String indexName() {
        return this.indexName;
    }

    @Nullable
    public final GuardrailsInputOutput inputGuardrail() {
        return this.inputGuardrail;
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final GuardrailsInputOutput outputGuardrail() {
        return this.outputGuardrail;
    }

    @Nonnull
    public final Map<String, JsonData> regex() {
        return this.regex;
    }

    @Nullable
    public final String responseFilter() {
        return this.responseFilter;
    }

    @Nullable
    public final String responseValidationRegex() {
        return this.responseValidationRegex;
    }

    @Nonnull
    public final List<String> sourceFields() {
        return this.sourceFields;
    }

    @Nonnull
    public final List<String> stopWords() {
        return this.stopWords;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.indexName != null) {
            generator.writeKey("index_name");
            generator.write(this.indexName);
        }
        if (this.inputGuardrail != null) {
            generator.writeKey("input_guardrail");
            this.inputGuardrail.serialize(generator, mapper);
        }
        if (this.modelId != null) {
            generator.writeKey("model_id");
            generator.write(this.modelId);
        }
        if (this.outputGuardrail != null) {
            generator.writeKey("output_guardrail");
            this.outputGuardrail.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.regex)) {
            generator.writeKey("regex");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.regex.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.responseFilter != null) {
            generator.writeKey("response_filter");
            generator.write(this.responseFilter);
        }
        if (this.responseValidationRegex != null) {
            generator.writeKey("response_validation_regex");
            generator.write(this.responseValidationRegex);
        }
        if (ApiTypeHelper.isDefined(this.sourceFields)) {
            generator.writeKey("source_fields");
            generator.writeStartArray();
            for (String string : this.sourceFields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.stopWords)) {
            generator.writeKey("stop_words");
            generator.writeStartArray();
            for (String string : this.stopWords) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGuardrailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexName, JsonpDeserializer.stringDeserializer(), "index_name");
        op.add(Builder::inputGuardrail, GuardrailsInputOutput._DESERIALIZER, "input_guardrail");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::outputGuardrail, GuardrailsInputOutput._DESERIALIZER, "output_guardrail");
        op.add(Builder::regex, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "regex");
        op.add(Builder::responseFilter, JsonpDeserializer.stringDeserializer(), "response_filter");
        op.add(Builder::responseValidationRegex, JsonpDeserializer.stringDeserializer(), "response_validation_regex");
        op.add(Builder::sourceFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "source_fields");
        op.add(Builder::stopWords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stop_words");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.indexName);
        result = 31 * result + Objects.hashCode(this.inputGuardrail);
        result = 31 * result + Objects.hashCode(this.modelId);
        result = 31 * result + Objects.hashCode(this.outputGuardrail);
        result = 31 * result + Objects.hashCode(this.regex);
        result = 31 * result + Objects.hashCode(this.responseFilter);
        result = 31 * result + Objects.hashCode(this.responseValidationRegex);
        result = 31 * result + Objects.hashCode(this.sourceFields);
        result = 31 * result + Objects.hashCode(this.stopWords);
        result = 31 * result + Objects.hashCode(this.type);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Guardrails other = (Guardrails)o;
        return Objects.equals(this.indexName, other.indexName) && Objects.equals(this.inputGuardrail, other.inputGuardrail) && Objects.equals(this.modelId, other.modelId) && Objects.equals(this.outputGuardrail, other.outputGuardrail) && Objects.equals(this.regex, other.regex) && Objects.equals(this.responseFilter, other.responseFilter) && Objects.equals(this.responseValidationRegex, other.responseValidationRegex) && Objects.equals(this.sourceFields, other.sourceFields) && Objects.equals(this.stopWords, other.stopWords) && Objects.equals(this.type, other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Guardrails> {
        @Nullable
        private String indexName;
        @Nullable
        private GuardrailsInputOutput inputGuardrail;
        @Nullable
        private String modelId;
        @Nullable
        private GuardrailsInputOutput outputGuardrail;
        @Nullable
        private Map<String, JsonData> regex;
        @Nullable
        private String responseFilter;
        @Nullable
        private String responseValidationRegex;
        @Nullable
        private List<String> sourceFields;
        @Nullable
        private List<String> stopWords;
        @Nullable
        private String type;

        public Builder() {
        }

        private Builder(Guardrails o) {
            this.indexName = o.indexName;
            this.inputGuardrail = o.inputGuardrail;
            this.modelId = o.modelId;
            this.outputGuardrail = o.outputGuardrail;
            this.regex = Builder._mapCopy(o.regex);
            this.responseFilter = o.responseFilter;
            this.responseValidationRegex = o.responseValidationRegex;
            this.sourceFields = Builder._listCopy(o.sourceFields);
            this.stopWords = Builder._listCopy(o.stopWords);
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.indexName = o.indexName;
            this.inputGuardrail = o.inputGuardrail;
            this.modelId = o.modelId;
            this.outputGuardrail = o.outputGuardrail;
            this.regex = Builder._mapCopy(o.regex);
            this.responseFilter = o.responseFilter;
            this.responseValidationRegex = o.responseValidationRegex;
            this.sourceFields = Builder._listCopy(o.sourceFields);
            this.stopWords = Builder._listCopy(o.stopWords);
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder indexName(@Nullable String value) {
            this.indexName = value;
            return this;
        }

        @Nonnull
        public final Builder inputGuardrail(@Nullable GuardrailsInputOutput value) {
            this.inputGuardrail = value;
            return this;
        }

        @Nonnull
        public final Builder inputGuardrail(Function<GuardrailsInputOutput.Builder, ObjectBuilder<GuardrailsInputOutput>> fn) {
            return this.inputGuardrail(fn.apply(new GuardrailsInputOutput.Builder()).build());
        }

        @Nonnull
        public final Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        @Nonnull
        public final Builder outputGuardrail(@Nullable GuardrailsInputOutput value) {
            this.outputGuardrail = value;
            return this;
        }

        @Nonnull
        public final Builder outputGuardrail(Function<GuardrailsInputOutput.Builder, ObjectBuilder<GuardrailsInputOutput>> fn) {
            return this.outputGuardrail(fn.apply(new GuardrailsInputOutput.Builder()).build());
        }

        @Nonnull
        public final Builder regex(Map<String, JsonData> map) {
            this.regex = Builder._mapPutAll(this.regex, map);
            return this;
        }

        @Nonnull
        public final Builder regex(String key, JsonData value) {
            this.regex = Builder._mapPut(this.regex, key, value);
            return this;
        }

        @Nonnull
        public final Builder responseFilter(@Nullable String value) {
            this.responseFilter = value;
            return this;
        }

        @Nonnull
        public final Builder responseValidationRegex(@Nullable String value) {
            this.responseValidationRegex = value;
            return this;
        }

        @Nonnull
        public final Builder sourceFields(List<String> list) {
            this.sourceFields = Builder._listAddAll(this.sourceFields, list);
            return this;
        }

        @Nonnull
        public final Builder sourceFields(String value, String ... values) {
            this.sourceFields = Builder._listAdd(this.sourceFields, value, values);
            return this;
        }

        @Nonnull
        public final Builder stopWords(List<String> list) {
            this.stopWords = Builder._listAddAll(this.stopWords, list);
            return this;
        }

        @Nonnull
        public final Builder stopWords(String value, String ... values) {
            this.stopWords = Builder._listAdd(this.stopWords, value, values);
            return this;
        }

        @Nonnull
        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public Guardrails build() {
            this._checkSingleUse();
            return new Guardrails(this);
        }
    }
}

