/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstLiteralExpression;
import com.jetbrains.python.ast.PyAstStringElement;
import com.jetbrains.python.psi.StringLiteralExpression;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface PyAstStringLiteralExpression
extends PyAstLiteralExpression,
StringLiteralExpression,
PsiLanguageInjectionHost {
    default public boolean isValidHost() {
        return true;
    }

    default public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            PyAstStringLiteralExpression.$$$reportNull$$$0(0);
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text);
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyStringLiteralExpression(this);
    }

    @NotNull
    default public List<ASTNode> getStringNodes() {
        TokenSet stringNodeTypes = TokenSet.orSet((TokenSet[])new TokenSet[]{PyTokenTypes.STRING_NODES, TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.FSTRING_NODE})});
        List<ASTNode> list = Arrays.asList(this.getNode().getChildren(stringNodeTypes));
        if (list == null) {
            PyAstStringLiteralExpression.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    default public List<? extends PyAstStringElement> getStringElements() {
        List list = StreamEx.of(this.getStringNodes()).map(ASTNode::getPsi).select(PyAstStringElement.class).toList();
        if (list == null) {
            PyAstStringLiteralExpression.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    default public List<TextRange> getStringValueTextRanges() {
        int elementStart = this.getTextRange().getStartOffset();
        List list = ContainerUtil.map(this.getStringElements(), node -> {
            int nodeRelativeOffset = node.getTextRange().getStartOffset() - elementStart;
            return node.getContentRange().shiftRight(nodeRelativeOffset);
        });
        if (list == null) {
            PyAstStringLiteralExpression.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    default public String getStringValue() {
        StringBuilder out = new StringBuilder();
        for (Pair<TextRange, String> fragment : this.getDecodedFragments()) {
            out.append((String)fragment.getSecond());
        }
        String string = out.toString();
        if (string == null) {
            PyAstStringLiteralExpression.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    default public List<Pair<TextRange, String>> getDecodedFragments() {
        int elementStart = this.getTextRange().getStartOffset();
        List list = StreamEx.of(this.getStringElements()).flatMap(node -> StreamEx.of(node.getDecodedFragments()).map(pair -> {
            int nodeRelativeOffset = node.getTextRange().getStartOffset() - elementStart;
            return Pair.create((Object)((TextRange)pair.getFirst()).shiftRight(nodeRelativeOffset), (Object)((String)pair.getSecond()));
        })).toList();
        if (list == null) {
            PyAstStringLiteralExpression.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    default public TextRange getStringValueTextRange() {
        List<TextRange> allRanges = this.getStringValueTextRanges();
        if (allRanges.size() == 1) {
            return allRanges.get(0);
        }
        if (allRanges.size() > 1) {
            return allRanges.get(0).union(allRanges.get(allRanges.size() - 1));
        }
        return new TextRange(0, this.getTextLength());
    }

    @NotNull
    default public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new LiteralTextEscaper<PyAstStringLiteralExpression>(this, this){

            public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
                if (rangeInsideHost == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outChars == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (Pair<TextRange, String> fragment : ((PyAstStringLiteralExpression)this.myHost).getDecodedFragments()) {
                    String intersectedValue;
                    TextRange encodedTextRange = (TextRange)fragment.getFirst();
                    TextRange intersection = encodedTextRange.intersection(rangeInsideHost);
                    if (intersection == null || intersection.isEmpty()) continue;
                    String value = (String)fragment.getSecond();
                    if (value.codePointCount(0, value.length()) == 1 || value.length() == intersection.getLength()) {
                        intersectedValue = value;
                    } else {
                        int start = Math.max(0, rangeInsideHost.getStartOffset() - encodedTextRange.getStartOffset());
                        int end = Math.min(value.length(), start + intersection.getLength());
                        intersectedValue = value.substring(start, end);
                    }
                    outChars.append(intersectedValue);
                }
                return true;
            }

            public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
                if (rangeInsideHost == null) {
                    1.$$$reportNull$$$0(2);
                }
                int offset = 0;
                int endOffset = -1;
                for (Pair<TextRange, String> fragment : ((PyAstStringLiteralExpression)this.myHost).getDecodedFragments()) {
                    TextRange encodedTextRange = (TextRange)fragment.getFirst();
                    TextRange intersection = encodedTextRange.intersection(rangeInsideHost);
                    if (intersection == null || intersection.isEmpty()) continue;
                    String value = (String)fragment.getSecond();
                    int valueLength = value.length();
                    int intersectionLength = intersection.getLength();
                    if (valueLength == 0) {
                        return -1;
                    }
                    if (value.codePointCount(0, valueLength) == 1) {
                        if (offset == offsetInDecoded) {
                            return intersection.getStartOffset();
                        }
                        offset += valueLength;
                    } else {
                        if (offset + intersectionLength >= offsetInDecoded) {
                            int delta = offsetInDecoded - offset;
                            return intersection.getStartOffset() + delta;
                        }
                        offset += intersectionLength;
                    }
                    endOffset = intersection.getEndOffset();
                }
                if (offset == offsetInDecoded) {
                    return endOffset;
                }
                return -1;
            }

            public boolean isOneLine() {
                return true;
            }

            @NotNull
            public TextRange getRelevantTextRange() {
                TextRange textRange = ((PyAstStringLiteralExpression)this.myHost).getStringValueTextRange();
                if (textRange == null) {
                    1.$$$reportNull$$$0(3);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rangeInsideHost";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outChars";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/ast/PyAstStringLiteralExpression$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/ast/PyAstStringLiteralExpression$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRelevantTextRange";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "decode";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getOffsetInHost";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    default public boolean isDocString() {
        List<ASTNode> stringNodes = this.getStringNodes();
        return stringNodes.size() == 1 && stringNodes.get(0).getElementType() == PyTokenTypes.DOCSTRING;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/ast/PyAstStringLiteralExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/ast/PyAstStringLiteralExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValueTextRanges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecodedFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

