/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.plugin.java.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.community.plugin.java.facet.PythonSdkEditorTab;
import com.jetbrains.python.facet.PythonFacetSettings;
import com.jetbrains.python.sdk.PythonSdkType;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class JavaPythonFacetConfiguration
extends PythonFacetSettings
implements FacetConfiguration {
    private static final String SDK_NAME = "sdkName";

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        return new FacetEditorTab[]{new PythonSdkEditorTab(editorContext)};
    }

    public void readExternal(Element element) throws InvalidDataException {
        String sdkName = element.getAttributeValue(SDK_NAME);
        this.mySdk = StringUtil.isEmpty((String)sdkName) ? null : ProjectJdkTable.getInstance().findJdk(sdkName, PythonSdkType.getInstance().getName());
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(SDK_NAME, this.mySdk == null ? "" : this.mySdk.getName());
    }
}

