/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.tokenizer;

import ai.grazie.text.Text;
import ai.grazie.text.TextRange;
import ai.grazie.utils.multiplatform.SafeJsExport;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SafeJsExport
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lai/grazie/nlp/tokenizer/JsTokenizerToken;", "", "text", "Lai/grazie/text/Text;", "interval", "Lai/grazie/text/TextRange;", "<init>", "(Lai/grazie/text/Text;Lai/grazie/text/TextRange;)V", "getText", "()Lai/grazie/text/Text;", "getInterval", "()Lai/grazie/text/TextRange;", "token", "", "getToken", "()Ljava/lang/String;", "merge", "other", "component1", "component2", "copy", "equals", "", "hashCode", "", "toString", "nlp-tokenizer"})
public final class JsTokenizerToken {
    @NotNull
    private final Text text;
    @NotNull
    private final TextRange interval;
    @NotNull
    private final String token;

    public JsTokenizerToken(@NotNull Text text2, @NotNull TextRange interval) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        this.text = text2;
        this.interval = interval;
        this.token = this.text.getValue();
    }

    @NotNull
    public final Text getText() {
        return this.text;
    }

    @NotNull
    public final TextRange getInterval() {
        return this.interval;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @NotNull
    public final JsTokenizerToken merge(@NotNull JsTokenizerToken other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.interval.getEndInclusive() == other.interval.getStart() - 1)) {
            boolean bl = false;
            String string = "Can't merge tokens which are not sequential. Ranges were [" + this.interval.getStart() + ", " + this.interval.getEndInclusive() + "] and [" + other.interval.getStart() + ", " + other.interval.getEndInclusive() + "].";
            throw new IllegalArgumentException(string.toString());
        }
        return new JsTokenizerToken(new Text(this.token + other.token), new TextRange(this.interval.getStart(), other.interval.getEndExclusive()));
    }

    @NotNull
    public final Text component1() {
        return this.text;
    }

    @NotNull
    public final TextRange component2() {
        return this.interval;
    }

    @NotNull
    public final JsTokenizerToken copy(@NotNull Text text2, @NotNull TextRange interval) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return new JsTokenizerToken(text2, interval);
    }

    public static /* synthetic */ JsTokenizerToken copy$default(JsTokenizerToken jsTokenizerToken, Text text2, TextRange textRange, int n, Object object) {
        if ((n & 1) != 0) {
            text2 = jsTokenizerToken.text;
        }
        if ((n & 2) != 0) {
            textRange = jsTokenizerToken.interval;
        }
        return jsTokenizerToken.copy(text2, textRange);
    }

    @NotNull
    public String toString() {
        return "JsTokenizerToken(text=" + this.text + ", interval=" + this.interval + ")";
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = result2 * 31 + this.interval.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsTokenizerToken)) {
            return false;
        }
        JsTokenizerToken jsTokenizerToken = (JsTokenizerToken)other;
        if (!Intrinsics.areEqual((Object)this.text, (Object)jsTokenizerToken.text)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.interval, (Object)jsTokenizerToken.interval);
    }
}

