/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TerminalMode {
    Null,
    CursorKey{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setApplicationArrowKeys(enabled);
        }
    }
    ,
    ANSI,
    WideColumn{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.clearScreen();
            terminal.resetScrollRegions();
        }
    }
    ,
    CursorVisible{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setCursorVisible(enabled);
        }
    }
    ,
    AlternateBuffer{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.useAlternateBuffer(enabled);
        }
    }
    ,
    SmoothScroll,
    ReverseVideo,
    OriginMode{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
        }
    }
    ,
    AutoWrap{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
        }
    }
    ,
    AutoRepeatKeys,
    Interlace,
    Keypad{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setApplicationKeypad(enabled);
        }
    }
    ,
    StoreCursor{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            if (enabled) {
                terminal.saveCursor();
            } else {
                terminal.restoreCursor();
            }
        }
    }
    ,
    AllowWideColumn,
    ReverseWrapAround,
    AutoNewLine{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setAutoNewLine(enabled);
        }
    }
    ,
    KeyboardAction,
    InsertMode,
    SendReceive,
    EightBitInput{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
        }
    }
    ,
    AltSendsEscape{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setAltSendsEscape(enabled);
        }
    }
    ,
    BracketedPasteMode{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setBracketedPasteMode(enabled);
        }
    };

    private static final Logger LOG;

    public void setEnabled(Terminal terminal, boolean enabled) {
        LOG.warn("Mode " + this.name() + " is not implemented, setting to " + enabled);
    }

    static {
        LOG = LoggerFactory.getLogger(TerminalMode.class);
    }
}

