/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.core.typeahead.TerminalTypeAheadManager;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TerminalExecutorServiceManager;
import com.jediterm.terminal.TerminalOutputStream;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.emulator.Emulator;
import com.jediterm.terminal.emulator.JediEmulator;
import com.jediterm.terminal.model.JediTerminal;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalStarter
implements TerminalOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(TerminalStarter.class);
    private final Emulator myEmulator;
    private final JediTerminal myTerminal;
    private final TtyConnector myTtyConnector;
    private final TerminalTypeAheadManager myTypeAheadManager;
    private final ScheduledExecutorService mySingleThreadScheduledExecutor;
    private volatile boolean myStopped = false;
    private volatile ScheduledFuture<?> myScheduledTtyConnectorResizeFuture;
    private volatile boolean myIsLastSentByteEscape = false;

    public TerminalStarter(@NotNull JediTerminal terminal, @NotNull TtyConnector ttyConnector, @NotNull TerminalDataStream dataStream, @NotNull TerminalTypeAheadManager typeAheadManager, @NotNull TerminalExecutorServiceManager executorServiceManager) {
        this.myTtyConnector = ttyConnector;
        this.myTerminal = terminal;
        this.myTerminal.setTerminalOutput(this);
        this.myEmulator = this.createEmulator(dataStream, terminal);
        this.myTypeAheadManager = typeAheadManager;
        this.mySingleThreadScheduledExecutor = executorServiceManager.getSingleThreadScheduledExecutor();
    }

    protected JediEmulator createEmulator(TerminalDataStream dataStream, Terminal terminal) {
        return new JediEmulator(dataStream, terminal);
    }

    private void execute(Runnable runnable) {
        if (!this.mySingleThreadScheduledExecutor.isShutdown()) {
            this.mySingleThreadScheduledExecutor.execute(runnable);
        }
    }

    @NotNull
    public TtyConnector getTtyConnector() {
        return this.myTtyConnector;
    }

    @NotNull
    public Terminal getTerminal() {
        return this.myTerminal;
    }

    public void start() {
        TerminalStarter.runUnderThreadName("TerminalEmulator-" + this.myTtyConnector.getName(), this::doStartEmulator);
    }

    private void doStartEmulator() {
        try {
            while (!Thread.currentThread().isInterrupted() && !this.myStopped && this.myEmulator.hasNext()) {
                this.myEmulator.next();
            }
        }
        catch (InterruptedIOException e) {
            LOG.debug("Terminal I/0 has been interrupted");
        }
        catch (Exception e) {
            if (this.myTtyConnector.isConnected()) {
                throw new RuntimeException("Uncaught exception in terminal emulator thread", e);
            }
        }
        finally {
            this.myTerminal.disconnected();
        }
    }

    public void requestEmulatorStop() {
        this.myStopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runUnderThreadName(@NotNull String threadName, @NotNull Runnable runnable) {
        Thread currentThread = Thread.currentThread();
        String oldThreadName = currentThread.getName();
        if (threadName.equals(oldThreadName)) {
            runnable.run();
        } else {
            currentThread.setName(threadName);
            try {
                runnable.run();
            }
            finally {
                currentThread.setName(oldThreadName);
            }
        }
    }

    @Deprecated
    public byte[] getCode(int key, int modifiers) {
        return this.myTerminal.getCodeForKey(key, modifiers);
    }

    public void postResize(@NotNull TermSize termSize, @NotNull RequestOrigin origin) {
        this.execute(() -> {
            this.myTerminal.resize(termSize, origin);
            this.scheduleTtyConnectorResize(termSize);
        });
    }

    private void scheduleTtyConnectorResize(@NotNull TermSize termSize) {
        ScheduledFuture<?> scheduledTtyConnectorResizeFuture = this.myScheduledTtyConnectorResizeFuture;
        if (scheduledTtyConnectorResizeFuture != null) {
            scheduledTtyConnectorResizeFuture.cancel(false);
        }
        long mergeDelay = this.myTerminal.getTerminalTextBuffer().isUsingAlternateBuffer() ? 100L : 500L;
        this.myScheduledTtyConnectorResizeFuture = this.mySingleThreadScheduledExecutor.schedule(() -> this.myTtyConnector.resize(termSize), mergeDelay, TimeUnit.MILLISECONDS);
    }

    @Deprecated(forRemoval=true)
    public static void resize(@NotNull Emulator emulator, @NotNull Terminal terminal, @NotNull TtyConnector ttyConnector, @NotNull TermSize newTermSize, @NotNull RequestOrigin origin, @NotNull BiConsumer<Long, Runnable> taskScheduler) {
        terminal.resize(newTermSize, origin);
        ttyConnector.resize(newTermSize);
    }

    @Override
    public void sendBytes(byte @NotNull [] bytes, boolean userInput) {
        int length = bytes.length;
        if (length > 0) {
            this.myIsLastSentByteEscape = bytes[length - 1] == 27;
        }
        this.execute(() -> {
            try {
                if (userInput) {
                    TerminalTypeAheadManager.TypeAheadEvent.fromByteArray(bytes).forEach(this.myTypeAheadManager::onKeyEvent);
                }
                this.myTtyConnector.write(bytes);
            }
            catch (IOException e) {
                this.logWriteError(e);
            }
        });
    }

    @Override
    public void sendString(@NotNull String string, boolean userInput) {
        int length = string.length();
        if (length > 0) {
            this.myIsLastSentByteEscape = string.charAt(length - 1) == '\u001b';
        }
        this.execute(() -> {
            try {
                if (userInput) {
                    TerminalTypeAheadManager.TypeAheadEvent.fromString(string).forEach(this.myTypeAheadManager::onKeyEvent);
                }
                this.myTtyConnector.write(string);
            }
            catch (IOException e) {
                this.logWriteError(e);
            }
        });
    }

    private void logWriteError(@NotNull IOException e) {
        LOG.info("Cannot write to TtyConnector " + this.myTtyConnector.getClass().getName() + ", connected: " + this.myTtyConnector.isConnected(), (Throwable)e);
    }

    public void close() {
        this.execute(() -> {
            try {
                this.myTtyConnector.close();
            }
            catch (Exception e) {
                LOG.error("Error closing terminal", (Throwable)e);
            }
        });
    }

    public boolean isLastSentByteEscape() {
        return this.myIsLastSentByteEscape;
    }
}

