/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.CorrectExample;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class CommaWhitespaceRule
extends Rule {
    private boolean quotesWhitespaceCheck;
    private Pattern FILE_EXTENSION = Pattern.compile("([a-z]{3,4}|[A-Z]{3,4}|ai|mp[34]|MP[34])(-.+)?");

    public CommaWhitespaceRule(ResourceBundle messages, IncorrectExample incorrectExample, CorrectExample correctExample, URL url) {
        super(messages);
        super.setCategory(Categories.TYPOGRAPHY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Whitespace);
        if (incorrectExample != null && correctExample != null) {
            this.addExamplePair(incorrectExample, correctExample);
        }
        if (url != null) {
            this.setUrl(url);
        }
        this.quotesWhitespaceCheck = true;
    }

    public CommaWhitespaceRule(ResourceBundle messages, IncorrectExample incorrectExample, CorrectExample correctExample) {
        this(messages, incorrectExample, correctExample, null);
    }

    public CommaWhitespaceRule(ResourceBundle messages, boolean quotesWhitespace) {
        this(messages, null, null);
        this.quotesWhitespaceCheck = quotesWhitespace;
    }

    public CommaWhitespaceRule(ResourceBundle messages) {
        this(messages, null, null);
        this.quotesWhitespaceCheck = true;
    }

    @Override
    public String getId() {
        return "COMMA_PARENTHESIS_WHITESPACE";
    }

    @Override
    public final String getDescription() {
        return this.messages.getString("desc_comma_whitespace");
    }

    public String getCommaCharacter() {
        return ",";
    }

    protected boolean isException(AnalyzedTokenReadings[] tokens, int tokenIdx) {
        return false;
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokens();
        String prevToken = "";
        String prevPrevToken = "";
        boolean prevWhite = false;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].getToken();
            boolean isWhitespace = CommaWhitespaceRule.isWhitespaceToken(tokens[i]);
            boolean twoSuggestions = false;
            String msg = null;
            Object suggestionText = null;
            if (isWhitespace && CommaWhitespaceRule.isLeftBracket(prevToken)) {
                boolean bl = isException = i + 1 < tokens.length && prevToken.equals("[") && token.equals(" ") && tokens[i + 1].getToken().equals("]");
                if (!isException) {
                    msg = this.messages.getString("no_space_after");
                    suggestionText = prevToken;
                }
            } else if (isWhitespace && CommaWhitespaceRule.isQuote(prevToken) && this.quotesWhitespaceCheck && prevPrevToken.equals(" ")) {
                msg = this.messages.getString("no_space_around_quotes");
                suggestionText = prevToken;
                twoSuggestions = true;
            } else if (!(isWhitespace || !prevToken.equals(this.getCommaCharacter()) || CommaWhitespaceRule.isQuote(token) || CommaWhitespaceRule.isHyphenOrComma(token) || CommaWhitespaceRule.containsDigit(prevPrevToken) || CommaWhitespaceRule.containsDigit(token) || ",".equals(prevPrevToken))) {
                msg = this.messages.getString("missing_space_after_comma");
                suggestionText = this.getCommaCharacter() + " " + tokens[i].getToken();
            } else if (prevWhite) {
                if (CommaWhitespaceRule.isRightBracket(token)) {
                    boolean bl = isException = token.equals("]") && prevToken.equals(" ") && prevPrevToken.equals("[");
                    if (!isException) {
                        msg = this.messages.getString("no_space_before");
                        suggestionText = token;
                    }
                } else if (token.equals(this.getCommaCharacter())) {
                    msg = this.messages.getString("space_after_comma");
                    suggestionText = this.getCommaCharacter();
                    if (i + 1 < tokens.length && this.getCommaCharacter().equals(tokens[i + 1].getToken())) {
                        msg = null;
                    }
                    if (i + 1 < tokens.length && !tokens[i + 1].isWhitespace()) {
                        suggestionText = this.getCommaCharacter() + " ";
                    }
                } else if (token.equals(".") && !this.isDomain(tokens, i + 1) && !this.isFileExtension(tokens, i + 1)) {
                    msg = this.messages.getString("no_space_before_dot");
                    suggestionText = ".";
                    if (i + 1 < tokens.length && CommaWhitespaceRule.isDigitOrDot(tokens[i + 1].getToken())) {
                        msg = null;
                    } else if (i + 2 < tokens.length && tokens[i + 1].getToken().equals("/") && tokens[i + 2].getToken().matches("[a-zA-Z]+")) {
                        msg = null;
                    }
                }
            }
            if (msg != null && !this.isException(tokens, i)) {
                String marked;
                String text;
                int toPos;
                int fromPos = tokens[i - 1].getStartPos();
                if (twoSuggestions) {
                    fromPos = tokens[i - 2].getStartPos();
                }
                if ((toPos = tokens[i].getEndPos()) < (text = sentence.getText()).length() && (marked = text.substring(fromPos, toPos)).equals(suggestionText) && !twoSuggestions) {
                    prevPrevToken = prevToken;
                    prevToken = token;
                    prevWhite = isWhitespace && !tokens[i].isFieldCode();
                    continue;
                }
                RuleMatch ruleMatch = new RuleMatch(this, sentence, fromPos, toPos, msg);
                if (twoSuggestions) {
                    ruleMatch.addSuggestedReplacement((String)suggestionText + " ");
                    ruleMatch.addSuggestedReplacement(" " + (String)suggestionText);
                } else {
                    ruleMatch.setSuggestedReplacement((String)suggestionText);
                }
                ruleMatches.add(ruleMatch);
            }
            prevPrevToken = prevToken;
            prevToken = token;
            prevWhite = isWhitespace && !tokens[i].isFieldCode();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isDomain(AnalyzedTokenReadings[] tokens, int i) {
        return i < tokens.length && tokens[i].getToken().matches("(?i)(com|org|net|int|edu|gov|mil|[a-z]{2})");
    }

    private boolean isFileExtension(AnalyzedTokenReadings[] tokens, int i) {
        return i < tokens.length && this.FILE_EXTENSION.matcher(tokens[i].getToken()).matches();
    }

    private static boolean isWhitespaceToken(AnalyzedTokenReadings token) {
        return (token.isWhitespace() || StringTools.isNonBreakingWhitespace(token.getToken()) || token.isFieldCode()) && !token.getToken().equals("\u200b");
    }

    private static boolean isQuote(String str) {
        if (str.length() == 1) {
            char c = str.charAt(0);
            return c == '\'' || c == '\"' || c == '\u2019' || c == '\u201d' || c == '\u201c' || c == '\u00ab' || c == '\u00bb';
        }
        return false;
    }

    private static boolean isHyphenOrComma(String str) {
        if (str.length() == 1) {
            char c = str.charAt(0);
            return c == '-' || c == ',';
        }
        return false;
    }

    private static boolean isDigitOrDot(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        char c = str.charAt(0);
        return c == '.' || Character.isDigit(c);
    }

    private static boolean isLeftBracket(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        char c = str.charAt(0);
        return c == '(';
    }

    private static boolean isRightBracket(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        char c = str.charAt(0);
        return c == ')';
    }

    private static boolean containsDigit(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isDigit(str.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

