/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.FormatterImpl;
import com.intellij.util.containers.ContainerUtil;
import java.text.ParsePosition;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CompositeFormatter
extends FormatterImpl {
    private final Formatter[] myFormatters;
    private final Formatter myBaseFormatter;
    @NotNull
    @Nls
    private final String myErrorMessage;

    public CompositeFormatter(@NotNull @Nls String errorMessage, @NotNull List<Formatter> formatters) {
        if (errorMessage == null) {
            CompositeFormatter.$$$reportNull$$$0(0);
        }
        if (formatters == null) {
            CompositeFormatter.$$$reportNull$$$0(1);
        }
        this(errorMessage, (Formatter[])ContainerUtil.toArray(formatters, Formatter[]::new));
    }

    public CompositeFormatter(@NotNull @Nls String errorMessage, Formatter ... formatters) {
        if (errorMessage == null) {
            CompositeFormatter.$$$reportNull$$$0(2);
        }
        if (formatters == null) {
            CompositeFormatter.$$$reportNull$$$0(3);
        }
        if (formatters.length == 0) {
            throw new IllegalArgumentException("Formatters must contains at least one formatter");
        }
        this.myBaseFormatter = formatters[0];
        this.myFormatters = formatters;
        this.myErrorMessage = errorMessage;
    }

    @Override
    public Object parse(@NotNull String value, @NotNull ParsePosition position) {
        if (value == null) {
            CompositeFormatter.$$$reportNull$$$0(4);
        }
        if (position == null) {
            CompositeFormatter.$$$reportNull$$$0(5);
        }
        ParsePosition internal = new ParsePosition(0);
        for (Formatter formatter : this.myFormatters) {
            internal.setIndex(0);
            internal.setErrorIndex(-1);
            Object result = formatter.parse(value, internal);
            if (internal.getErrorIndex() != -1 || internal.getIndex() != value.length()) continue;
            position.setIndex(internal.getIndex());
            return result;
        }
        position.setErrorIndex(internal.getErrorIndex());
        return null;
    }

    @Override
    @Nls
    @NotNull
    protected String getErrorMessage() {
        String string = this.myErrorMessage;
        if (string == null) {
            CompositeFormatter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public String format(@NotNull Object value) {
        if (value == null) {
            CompositeFormatter.$$$reportNull$$$0(7);
        }
        return this.myBaseFormatter.format(value);
    }

    public String toString() {
        return this.myBaseFormatter.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatters";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/CompositeFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/CompositeFormatter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

