/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.debugger.PyDebugValue;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class PyTypeHandler {
    private static final Formatter DEFAULT_FORMATTER = new Formatter(){

        @Override
        public String format(String value) {
            return value;
        }
    };
    private static final Formatter STR_FORMATTER = new Formatter(){

        @Override
        public String format(String value) {
            String escapedString = StringUtil.replace((String)value, (String)"\\", (String)"\\\\");
            if (value.contains("'")) {
                return "\"" + PyTypeHandler.processNonPrintableChars(escapedString) + "\"";
            }
            return "'" + PyTypeHandler.processNonPrintableChars(escapedString) + "'";
        }
    };
    private static final Formatter UNI_FORMATTER = new Formatter(){

        @Override
        public String format(String value) {
            String escapedString = StringUtil.replace((String)value, (String)"\\", (String)"\\\\");
            if (value.contains("'")) {
                return "u\"" + escapedString + "\"";
            }
            return "u'" + escapedString + "'";
        }
    };
    private static final Map<String, Formatter> FORMATTERS = new HashMap<String, Formatter>();

    private static boolean isNonPrintable(char c) {
        return c < ' ' && c != '\t' && c != '\n' && c != '\r' || c > '\u007f' && c < '\u00a0';
    }

    @NotNull
    private static String charToHEX(char c) {
        String string = String.format("%02x", c);
        if (string == null) {
            PyTypeHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String processNonPrintableChars(@NotNull String string) {
        if (string == null) {
            PyTypeHandler.$$$reportNull$$$0(1);
        }
        StringBuilder result = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (PyTypeHandler.isNonPrintable(c)) {
                result.append("\\x");
                result.append(PyTypeHandler.charToHEX(c));
                continue;
            }
            result.append(c);
        }
        String string2 = result.toString();
        if (string2 == null) {
            PyTypeHandler.$$$reportNull$$$0(2);
        }
        return string2;
    }

    private PyTypeHandler() {
    }

    public static String format(PyDebugValue var) {
        return PyTypeHandler.format(var.getType(), var.getValue());
    }

    public static String format(String type, String value) {
        Formatter formatter = FORMATTERS.get(type);
        if (formatter == null) {
            formatter = DEFAULT_FORMATTER;
        }
        return formatter.format(value);
    }

    static {
        FORMATTERS.put("str", STR_FORMATTER);
        FORMATTERS.put("unicode", UNI_FORMATTER);
        FORMATTERS.put("string_", STR_FORMATTER);
        FORMATTERS.put("unicode_", UNI_FORMATTER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyTypeHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "charToHEX";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyTypeHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processNonPrintableChars";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processNonPrintableChars";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static interface Formatter {
        public String format(String var1);
    }
}

