/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config.ui;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpRecursiveElementVisitor;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.jetbrains.annotations.NotNull;

public final class ValueRegExpAnnotator
implements Annotator {
    public static final Key<Boolean> KEY = Key.create((String)"IS_VALUE_REGEXP");

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            ValueRegExpAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ValueRegExpAnnotator.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof RegExpFile && psiElement.getCopyableUserData(KEY) == Boolean.TRUE) {
            PsiElement pattern = psiElement.getFirstChild();
            if (!(pattern instanceof RegExpPattern)) {
                return;
            }
            RegExpBranch[] branches = ((RegExpPattern)pattern).getBranches();
            if (branches.length == 1 && branches[0].getAtoms().length == 0) {
                return;
            }
            for (RegExpBranch branch : branches) {
                final int[] count = new int[1];
                branch.accept((PsiElementVisitor)new RegExpRecursiveElementVisitor(this){

                    public void visitRegExpGroup(RegExpGroup group) {
                        if (group.isCapturing()) {
                            count[0] = count[0] + 1;
                        }
                        super.visitRegExpGroup(group);
                    }
                });
                if (count[0] == 1) continue;
                holder.newAnnotation(HighlightSeverity.WARNING, IntelliLangBundle.message("annotation.message.the.pattern", new Object[0])).range((PsiElement)branch).create();
            }
        }
    }

    static {
        LanguageAnnotators.INSTANCE.addExplicitExtension((Language)RegExpLanguage.INSTANCE, (Object)new ValueRegExpAnnotator());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/intellij/plugins/intelliLang/inject/config/ui/ValueRegExpAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

