/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyCustomType
implements PyClassLikeType {
    @NotNull
    private final List<PyClassLikeType> myTypesToMimic;
    @Nullable
    private final Processor<PyElement> myFilter;
    private final boolean myInstanceType;
    private final boolean myTypesToMimicAsSuperTypes;
    @Nullable
    private final String myQualifiedName;

    public PyCustomType(@Nullable String qualifiedName, @Nullable Processor<PyElement> filter, boolean instanceType, boolean typesToMimicAsSuperTypes, PyClassLikeType ... typesToMimic) {
        if (typesToMimic == null) {
            PyCustomType.$$$reportNull$$$0(0);
        }
        this.myQualifiedName = qualifiedName;
        this.myFilter = filter;
        this.myInstanceType = instanceType;
        this.myTypesToMimicAsSuperTypes = typesToMimicAsSuperTypes;
        this.myTypesToMimic = StreamEx.of((Object[])typesToMimic).nonNull().map(t -> instanceType ? (PyClassLikeType)t.toInstance() : (PyClassLikeType)t.toClass()).toImmutableList();
    }

    @NotNull
    public List<PyClassLikeType> getTypesToMimic() {
        List<PyClassLikeType> list = this.myTypesToMimic;
        if (list == null) {
            PyCustomType.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean isDefinition() {
        return !this.myInstanceType;
    }

    @NotNull
    public PyClassLikeType toInstance() {
        return this.myInstanceType ? this : new PyCustomType(this.myQualifiedName, this.myFilter, true, this.myTypesToMimicAsSuperTypes, this.myTypesToMimic.toArray(new PyClassLikeType[0]));
    }

    @NotNull
    public PyClassLikeType toClass() {
        PyCustomType pyCustomType = this.myInstanceType ? new PyCustomType(this.myQualifiedName, this.myFilter, false, this.myTypesToMimicAsSuperTypes, this.myTypesToMimic.toArray(new PyClassLikeType[0])) : this;
        if (pyCustomType == null) {
            PyCustomType.$$$reportNull$$$0(2);
        }
        return pyCustomType;
    }

    @Nullable
    @NlsSafe
    public String getClassQName() {
        return this.myQualifiedName;
    }

    @NotNull
    public List<PyClassLikeType> getSuperClassTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyCustomType.$$$reportNull$$$0(3);
        }
        List<Object> list = this.myTypesToMimicAsSuperTypes ? this.myTypesToMimic : Collections.emptyList();
        if (list == null) {
            PyCustomType.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext, boolean inherited) {
        if (name == null) {
            PyCustomType.$$$reportNull$$$0(5);
        }
        if (direction == null) {
            PyCustomType.$$$reportNull$$$0(6);
        }
        if (resolveContext == null) {
            PyCustomType.$$$reportNull$$$0(7);
        }
        ArrayList globalResult = new ArrayList();
        for (PyClassLikeType typeToMimic : this.myTypesToMimic) {
            List results = typeToMimic.resolveMember(name, location, direction, resolveContext, inherited);
            if (results == null) continue;
            globalResult.addAll(Collections2.filter((Collection)results, (Predicate)new ResolveFilter()));
        }
        ArrayList arrayList = globalResult;
        if (arrayList == null) {
            PyCustomType.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public boolean isValid() {
        return ContainerUtil.and(this.myTypesToMimic, PyClassLikeType::isValid);
    }

    @Nullable
    public PyClassLikeType getMetaClassType(@NotNull TypeEvalContext context, boolean inherited) {
        PyClassLikeType typeToMimic;
        if (context == null) {
            PyCustomType.$$$reportNull$$$0(9);
        }
        if (inherited && (typeToMimic = (PyClassLikeType)ContainerUtil.getFirstItem(this.myTypesToMimic)) != null) {
            return typeToMimic.getMetaClassType(context, inherited);
        }
        return null;
    }

    public boolean isCallable() {
        return !this.myInstanceType || "typing.Callable".equals(this.myQualifiedName) || ContainerUtil.or(this.myTypesToMimic, PyCallableType::isCallable);
    }

    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyCustomType.$$$reportNull$$$0(10);
        }
        return this.myInstanceType ? null : this.toInstance();
    }

    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyCustomType.$$$reportNull$$$0(11);
        }
        if (callSite == null) {
            PyCustomType.$$$reportNull$$$0(12);
        }
        return this.getReturnType(context);
    }

    @NotNull
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            PyCustomType.$$$reportNull$$$0(13);
        }
        if (direction == null) {
            PyCustomType.$$$reportNull$$$0(14);
        }
        if (resolveContext == null) {
            PyCustomType.$$$reportNull$$$0(15);
        }
        List<? extends RatedResolveResult> list = this.resolveMember(name, location, direction, resolveContext, true);
        if (list == null) {
            PyCustomType.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public List<PyClassLikeType> getAncestorTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyCustomType.$$$reportNull$$$0(17);
        }
        if (!this.myTypesToMimicAsSuperTypes) {
            List<PyClassLikeType> list = Collections.emptyList();
            if (list == null) {
                PyCustomType.$$$reportNull$$$0(18);
            }
            return list;
        }
        LinkedHashSet<PyClassLikeType> result = new LinkedHashSet<PyClassLikeType>();
        for (PyClassLikeType type : this.myTypesToMimic) {
            result.add(type);
            result.addAll(type.getAncestorTypes(context));
        }
        return new ArrayList<PyClassLikeType>(result);
    }

    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        ArrayList lookupElements = new ArrayList();
        for (PyClassLikeType parentType : this.myTypesToMimic) {
            lookupElements.addAll(Collections2.filter(Arrays.asList(parentType.getCompletionVariants(completionPrefix, location, context)), (Predicate)new CompletionFilter()));
        }
        return ArrayUtil.toObjectArray(lookupElements);
    }

    @Nullable
    public String getName() {
        if (this.myQualifiedName != null) {
            return QualifiedName.fromDottedString((String)this.myQualifiedName).getLastComponent();
        }
        ArrayList<String> classNames = new ArrayList<String>(this.myTypesToMimic.size());
        for (PyClassLikeType type : this.myTypesToMimic) {
            String name = type.getName();
            if (name == null && type instanceof PyClassType) {
                name = ((PyClassType)type).getPyClass().getName();
            }
            if (name == null) continue;
            classNames.add(name);
        }
        return PyPsiBundle.message("custom.type.mimic.name", StringUtil.join(classNames, (String)","));
    }

    public boolean isBuiltin() {
        return false;
    }

    public void assertValid(String message) {
        for (PyClassLikeType type : this.myTypesToMimic) {
            type.assertValid(message);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PyCustomType)) {
            return false;
        }
        PyCustomType type = (PyCustomType)o;
        return this.myInstanceType == type.myInstanceType && this.myTypesToMimicAsSuperTypes == type.myTypesToMimicAsSuperTypes && Objects.equals(this.myTypesToMimic, type.myTypesToMimic) && Objects.equals(this.myQualifiedName, type.myQualifiedName);
    }

    public int hashCode() {
        return Objects.hash(this.myInstanceType, this.myTypesToMimicAsSuperTypes, this.myQualifiedName, this.myTypesToMimic);
    }

    public void visitMembers(@NotNull Processor<? super PsiElement> processor2, boolean inherited, @NotNull TypeEvalContext context) {
        if (processor2 == null) {
            PyCustomType.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyCustomType.$$$reportNull$$$0(20);
        }
        for (PyClassLikeType type : this.myTypesToMimic) {
            type.visitMembers(t -> {
                if (!(t instanceof PyElement)) {
                    return true;
                }
                if (this.myFilter == null || this.myFilter.process((Object)((PyElement)t))) {
                    return processor2.process(t);
                }
                return true;
            }, inherited, context);
        }
    }

    @NotNull
    public Set<String> getMemberNames(boolean inherited, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyCustomType.$$$reportNull$$$0(21);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (PyClassLikeType type : this.myTypesToMimic) {
            result.addAll(type.getMemberNames(inherited, context));
        }
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            PyCustomType.$$$reportNull$$$0(22);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 8, 16, 18, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesToMimic";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PyCustomType";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PyCustomType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesToMimic";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassTypes";
                break;
            }
            case 8: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMember";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorTypes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 18: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassTypes";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMetaClassType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorTypes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitMembers";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMemberNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 8, 16, 18, 22 -> new IllegalStateException(string);
        };
    }

    private class ResolveFilter
    implements Predicate<RatedResolveResult> {
        private ResolveFilter() {
        }

        public boolean apply(@Nullable RatedResolveResult input) {
            if (input == null) {
                return false;
            }
            if (PyCustomType.this.myFilter == null) {
                return true;
            }
            PyElement pyElement = PyUtil.as(input.getElement(), PyElement.class);
            if (pyElement == null) {
                return false;
            }
            return PyCustomType.this.myFilter.process((Object)pyElement);
        }
    }

    private class CompletionFilter
    implements Predicate<Object> {
        private CompletionFilter() {
        }

        public boolean apply(@Nullable Object input) {
            if (input == null) {
                return false;
            }
            if (PyCustomType.this.myFilter == null) {
                return true;
            }
            if (!(input instanceof LookupElement)) {
                return true;
            }
            PyElement pyElement = PyUtil.as(((LookupElement)input).getPsiElement(), PyElement.class);
            if (pyElement == null) {
                return false;
            }
            return PyCustomType.this.myFilter.process((Object)pyElement);
        }
    }
}

