/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.poetry;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PyInterpreterInspectionQuickFixData;
import com.jetbrains.python.sdk.PySdkProvider;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import com.jetbrains.python.sdk.poetry.PyPoetrySdkAdditionalData;
import com.jetbrains.python.sdk.poetry.quickFixes.PoetryAssociationQuickFix;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/sdk/poetry/PoetrySdkProvider;", "Lcom/jetbrains/python/sdk/PySdkProvider;", "<init>", "()V", "createEnvironmentAssociationFix", "Lcom/jetbrains/python/sdk/PyInterpreterInspectionQuickFixData;", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isPyCharm", "", "associatedModulePath", "", "getSdkAdditionalText", "getSdkIcon", "Ljavax/swing/Icon;", "loadAdditionalDataForSdk", "Lcom/intellij/openapi/projectRoots/SdkAdditionalData;", "element", "Lorg/jdom/Element;", "intellij.python.community.impl"})
public final class PoetrySdkProvider
implements PySdkProvider {
    @Override
    @Nullable
    public PyInterpreterInspectionQuickFixData createEnvironmentAssociationFix(@NotNull Module module2, @NotNull Sdk sdk2, boolean isPyCharm, @Nullable String associatedModulePath) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        if (PoetryKt.isPoetry(sdk2)) {
            String string;
            String projectUnit = isPyCharm ? "project" : "module";
            if (associatedModulePath != null) {
                var8_6 = new Object[]{projectUnit, associatedModulePath};
                string = PyBundle.message("python.sdk.inspection.message.poetry.interpreter.associated.with.another.project", var8_6);
            } else {
                var8_6 = new Object[]{projectUnit};
                string = PyBundle.message("python.sdk.inspection.message.poetry.interpreter.not.associated.with.any.project", var8_6);
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String message = string2;
            return new PyInterpreterInspectionQuickFixData(new PoetryAssociationQuickFix(), message);
        }
        return null;
    }

    @Override
    @Nullable
    public String getSdkAdditionalText(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        return PoetryKt.isPoetry(sdk2) ? sdk2.getVersionString() : null;
    }

    @Override
    @Nullable
    public Icon getSdkIcon(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        return PoetryKt.isPoetry(sdk2) ? PoetryKt.getPOETRY_ICON() : null;
    }

    @Override
    @Nullable
    public SdkAdditionalData loadAdditionalDataForSdk(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return (SdkAdditionalData)PyPoetrySdkAdditionalData.Companion.load(element);
    }
}

