/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.AngleApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.JvmContextHandler;
import org.jetbrains.skiko.redrawer.AngleRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/skiko/context/AngleContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "angleRedrawer", "Lorg/jetbrains/skiko/redrawer/AngleRedrawer;", "getAngleRedrawer", "()Lorg/jetbrains/skiko/redrawer/AngleRedrawer;", "currentHeight", "", "currentWidth", "initCanvas", "", "initContext", "", "isSizeChanged", "width", "height", "rendererInfo", "", "skiko"})
@SourceDebugExtension(value={"SMAP\nAngleContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AngleContextHandler.kt\norg/jetbrains/skiko/context/AngleContextHandler\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,73:1\n124#2,4:74\n159#2,4:78\n*S KotlinDebug\n*F\n+ 1 AngleContextHandler.kt\norg/jetbrains/skiko/context/AngleContextHandler\n*L\n19#1:74,4\n23#1:78,4\n*E\n"})
public final class AngleContextHandler
extends JvmContextHandler {
    private int currentWidth;
    private int currentHeight;

    public AngleContextHandler(@NotNull SkiaLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super(layer);
    }

    private final AngleRedrawer getAngleRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (AngleRedrawer)redrawer;
    }

    @Override
    protected boolean initContext() {
        try {
            if (this.getContext() == null) {
                this.setContext(this.getAngleRedrawer().makeContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true")) {
                    Logger this_$iv = Logger.INSTANCE;
                    boolean $i$f$info = false;
                    if (this_$iv.getLoggerImpl().isInfoEnabled()) {
                        SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                        boolean bl = false;
                        skikoLoggerInterface.info("Renderer info:\n " + this.rendererInfo());
                    }
                }
            }
        }
        catch (Exception e) {
            Logger this_$iv = Logger.INSTANCE;
            boolean $i$f$warn = false;
            if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                Throwable throwable = e;
                SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                boolean bl = false;
                String string = "Failed to create Skia ANGLE context!";
                skikoLoggerInterface.warn(throwable, string);
            }
            return false;
        }
        return true;
    }

    private final boolean isSizeChanged(int width2, int height2) {
        if (width2 != this.currentWidth || height2 != this.currentHeight) {
            this.currentWidth = width2;
            this.currentHeight = height2;
            return true;
        }
        return false;
    }

    @Override
    protected void initCanvas() {
        int h;
        DirectContext directContext = this.getContext();
        if (directContext == null) {
            return;
        }
        DirectContext context = directContext;
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        if (this.isSizeChanged(w, h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0)) || this.getSurface() == null) {
            this.disposeCanvas();
            context.flush();
            this.setRenderTarget(this.getAngleRedrawer().makeRenderTarget(w, h));
            BackendRenderTarget backendRenderTarget = this.getRenderTarget();
            Intrinsics.checkNotNull((Object)backendRenderTarget);
            Surface surface = Surface.Companion.makeFromBackendRenderTarget(context, backendRenderTarget, SurfaceOrigin.BOTTOM_LEFT, SurfaceColorFormat.RGBA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null));
            if (surface == null) {
                throw new RenderException("Cannot create surface", null, 2, null);
            }
            this.setSurface(surface);
        }
        Surface surface = this.getSurface();
        Intrinsics.checkNotNull((Object)surface);
        this.setCanvas(surface.getCanvas());
    }

    @Override
    @NotNull
    public String rendererInfo() {
        return super.rendererInfo() + "Vendor: " + AngleApi.INSTANCE.glGetString(AngleApi.INSTANCE.getGL_VENDOR()) + "\nModel: " + AngleApi.INSTANCE.glGetString(AngleApi.INSTANCE.getGL_RENDERER()) + "\nVersion: " + AngleApi.INSTANCE.glGetString(AngleApi.INSTANCE.getGL_VERSION()) + '\n';
    }
}

