/*
 * Decompiled with CFR 0.152.
 */
package training.project;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskBuilder;
import com.intellij.ide.impl.TrustedPaths;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.LearnBundle;
import training.util.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00130\u0019J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0015JA\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(2!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00130\u0019J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0017H\u0002JC\u0010+\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u00152!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00130\u0019H\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010\u000b2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u00100\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u000bH\u0002J\u0010\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u000bH\u0002J\u0018\u00104\u001a\n 5*\u0004\u0018\u00010\u000b0\u000b2\u0006\u00106\u001a\u00020\u000bH\u0002J\u0016\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u00172\u0006\u00109\u001a\u00020\u0005J\u0018\u0010:\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u00152\u0006\u00108\u001a\u00020\u0017H\u0007J\u0010\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\bj\b\u0012\u0004\u0012\u00020\u0005`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\u00a8\u0006="}, d2={"Ltraining/project/ProjectUtils;", "", "<init>", "()V", "LEARNING_PROJECT_MODIFICATION", "", "FEATURE_TRAINER_VERSION", "protectedDirNames", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "customSystemPath", "Ljava/nio/file/Path;", "getCustomSystemPath", "()Ljava/nio/file/Path;", "setCustomSystemPath", "(Ljava/nio/file/Path;)V", "learningProjectsPath", "getLearningProjectsPath", "importOrOpenProject", "", "langSupport", "Ltraining/lang/LangSupport;", "projectToClose", "Lcom/intellij/openapi/project/Project;", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "learnProject", "getLearningInstallationContentRoot", "createProjectDirectory", "", "place", "getCurrentLearningProjectRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProjectRoot", "languageSupport", "simpleInstallAndOpenLearningProject", "contentRoot", "openProjectTask", "Lcom/intellij/ide/impl/OpenProjectTask;", "updateLearningModificationTimestamp", "it", "openOrImportLearningProject", "copyLearningProjectFiles", "newContentDirectory", "learningProjectUrl", "Ljava/net/URL;", "chooseParentDirectoryForLearningProject", "createVersionFile", "newProjectDirectory", "isSameVersion", "versionFile", "kotlin.jvm.PlatformType", "dest", "markDirectoryAsSourcesRoot", "project", "pathToSources", "restoreProject", "isEmptyDir", "path", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nProjectUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectUtils.kt\ntraining/project/ProjectUtils\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,381:1\n42#2,10:382\n23#3:392\n23#3:397\n11561#4:393\n11896#4,3:394\n1#5:398\n*S KotlinDebug\n*F\n+ 1 ProjectUtils.kt\ntraining/project/ProjectUtils\n*L\n64#1:382,10\n261#1:392\n369#1:397\n261#1:393\n261#1:394,3\n*E\n"})
public final class ProjectUtils {
    @NotNull
    public static final ProjectUtils INSTANCE = new ProjectUtils();
    @NotNull
    private static final String LEARNING_PROJECT_MODIFICATION = "LEARNING_PROJECT_MODIFICATION";
    @NotNull
    private static final String FEATURE_TRAINER_VERSION = "feature-trainer-version.txt";
    @NotNull
    private static final HashSet<String> protectedDirNames;
    @ApiStatus.Internal
    @Nullable
    private static volatile Path customSystemPath;

    private ProjectUtils() {
    }

    @Nullable
    public final Path getCustomSystemPath() {
        return customSystemPath;
    }

    @TestOnly
    public final void setCustomSystemPath(@Nullable Path path) {
        customSystemPath = path;
    }

    @NotNull
    public final Path getLearningProjectsPath() {
        Object object = customSystemPath;
        if (object == null || (object = object.toString()) == null) {
            String string = PathManager.getSystemPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSystemPath(...)");
        }
        String[] stringArray = new String[]{"demo"};
        Path path = Paths.get((String)object, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    public final void importOrOpenProject(@NotNull LangSupport langSupport, @Nullable Project projectToClose, @NotNull Function1<? super Project, Unit> postInitCallback) {
        void title$iv;
        Intrinsics.checkNotNullParameter((Object)langSupport, (String)"langSupport");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        String string = LearnBundle.INSTANCE.message("learn.project.initializing.process", new Object[0]);
        Project project$iv = projectToClose;
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, langSupport, projectToClose, postInitCallback){
            final /* synthetic */ LangSupport $langSupport$inlined;
            final /* synthetic */ Project $projectToClose$inlined;
            final /* synthetic */ Function1 $postInitCallback$inlined;
            {
                this.$langSupport$inlined = langSupport;
                this.$projectToClose$inlined = project;
                this.$postInitCallback$inlined = function1;
                super($project, $title, $cancellable);
            }

            /*
             * WARNING - void declaration
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator it = indicator;
                boolean bl = false;
                Path path = ProjectUtils.access$getLearningInstallationContentRoot(ProjectUtils.INSTANCE, this.$langSupport$inlined);
                if (path != null) {
                    Path dest = path;
                    Path path2 = ProjectUtils.access$versionFile(ProjectUtils.INSTANCE, dest);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"access$versionFile(...)");
                    if (!ProjectUtils.access$isSameVersion(ProjectUtils.INSTANCE, path2)) {
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (Files.exists(dest, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            PathKt.delete$default((Path)dest, (boolean)false, (int)1, null);
                        }
                        this.$langSupport$inlined.installAndOpenLearningProject(dest, this.$projectToClose$inlined, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>((Function1<? super Project, Unit>)this.$postInitCallback$inlined){
                            final /* synthetic */ Function1<Project, Unit> $postInitCallback;
                            {
                                this.$postInitCallback = $postInitCallback;
                            }

                            public final void invoke(Project it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                this.$postInitCallback.invoke((Object)it);
                            }
                        }));
                    } else {
                        void $this$importOrOpenProject_u24lambda_u240_u240;
                        String path3 = ((Object)this.$langSupport$inlined.getLearningProjectPath(dest).toAbsolutePath()).toString();
                        LangManager.Companion.getInstance().setLearningProjectPath(this.$langSupport$inlined, path3);
                        boolean $i$f$OpenProjectTask = false;
                        OpenProjectTaskBuilder this_$iv$iv = new OpenProjectTaskBuilder();
                        boolean $i$f$build = false;
                        OpenProjectTaskBuilder openProjectTaskBuilder = this_$iv$iv;
                        Path path4 = dest;
                        ProjectUtils projectUtils = ProjectUtils.INSTANCE;
                        boolean bl2 = false;
                        $this$importOrOpenProject_u24lambda_u240_u240.setProjectToClose(this.$projectToClose$inlined);
                        Unit unit = Unit.INSTANCE;
                        boolean bl3 = this_$iv$iv.getForceOpenInNewFrame();
                        boolean bl4 = this_$iv$iv.getForceReuseFrame();
                        boolean bl5 = this_$iv$iv.getPreloadServices();
                        Project project = this_$iv$iv.getProjectToClose();
                        boolean bl6 = this_$iv$iv.isRefreshVfsNeeded();
                        String string = this_$iv$iv.getProjectName();
                        boolean bl7 = this_$iv$iv.isNewProject();
                        Boolean bl8 = this_$iv$iv.getUseDefaultProjectAsTemplate();
                        boolean bl9 = bl8 != null ? bl8.booleanValue() : this_$iv$iv.isNewProject();
                        boolean bl10 = this_$iv$iv.getRunConfigurators();
                        boolean bl11 = this_$iv$iv.isProjectCreatedWithWizard();
                        boolean bl12 = this_$iv$iv.getRunConversionBeforeOpen();
                        boolean bl13 = this_$iv$iv.getShowWelcomeScreen();
                        Function2 function2 = this_$iv$iv.getBeforeOpen();
                        Function1 function1 = this_$iv$iv.getBeforeInit();
                        Function2 function22 = this_$iv$iv.getPreparedToOpen();
                        ProjectOpenedCallback projectOpenedCallback = this_$iv$iv.getCallback();
                        boolean bl14 = this_$iv$iv.getPreventIprLookup();
                        Function1 function12 = this_$iv$iv.getProcessorChooser();
                        String string2 = this_$iv$iv.getProjectWorkspaceId();
                        Object object = this_$iv$iv.getImplOptions();
                        boolean bl15 = this_$iv$iv.getCreateModule();
                        int n = this_$iv$iv.getLine();
                        int n2 = this_$iv$iv.getColumn();
                        Project project2 = this_$iv$iv.getProject();
                        Path path5 = this_$iv$iv.getProjectRootDir();
                        ProjectUtils.access$openOrImportLearningProject(projectUtils, path4, new OpenProjectTask(bl3, bl4, project, bl7, bl9, project2, string, bl13, projectOpenedCallback, n, n2, bl6, bl10, bl12, string2, bl11, bl5, function1, function2, function22, bl14, function12, object, path5, bl15), this.$langSupport$inlined, this.$postInitCallback$inlined);
                    }
                }
            }
        });
    }

    private final Path getLearningInstallationContentRoot(LangSupport langSupport) {
        Path path;
        Path path2;
        String storedProjectPath;
        String string = storedProjectPath = LangManager.Companion.getInstance().getLearningProjectPath(langSupport.getPrimaryLanguage());
        if (string != null) {
            Path path3 = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            path2 = langSupport.getContentRootPath(path3);
        } else {
            path2 = null;
        }
        Path path4 = path2;
        Path canonicalPlace = this.getLearningProjectsPath().resolve(langSupport.getContentRootDirectoryName());
        boolean useCanonical = true;
        if (path4 != null && !Intrinsics.areEqual((Object)path4, (Object)canonicalPlace)) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(path4, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path path5 = this.versionFile(path4);
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"versionFile(...)");
                Path path6 = path5;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.exists(path6, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    Intrinsics.checkNotNull((Object)canonicalPlace);
                    if (this.createProjectDirectory(canonicalPlace)) {
                        RecentProjectListActionProvider rpProvider = RecentProjectListActionProvider.Companion.getInstance();
                        List projectActions = RecentProjectListActionProvider.getActionsWithoutGroups$default((RecentProjectListActionProvider)rpProvider, (boolean)false, null, (int)3, null);
                        for (AnAction action : projectActions) {
                            ReopenProjectAction reopenProjectAction = action instanceof ReopenProjectAction ? (ReopenProjectAction)action : null;
                            String projectPath = reopenProjectAction != null ? reopenProjectAction.getProjectPath() : null;
                            if (projectPath == null || !Intrinsics.areEqual((Object)Paths.get(projectPath, new String[0]), (Object)path4)) continue;
                            RecentProjectsManager.Companion.getInstance().removePath(projectPath);
                        }
                        PathKt.delete((Path)path4, (boolean)true);
                    } else {
                        useCanonical = false;
                    }
                }
            }
        }
        if (useCanonical) {
            Intrinsics.checkNotNull((Object)canonicalPlace);
            if (this.createProjectDirectory(canonicalPlace)) {
                path = canonicalPlace;
            } else {
                path = (Path)ActionsKt.invokeAndWaitIfNeeded$default(null, () -> ProjectUtils.getLearningInstallationContentRoot$lambda$0(langSupport), (int)1, null);
                if (path == null) {
                    return null;
                }
            }
        } else {
            Path path7 = path4;
            path = path7;
            Intrinsics.checkNotNull((Object)path7);
        }
        return path;
    }

    private final boolean createProjectDirectory(Path place) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(place, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return true;
        }
        try {
            PathKt.createDirectories((Path)place);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public final VirtualFile getCurrentLearningProjectRoot() {
        LangSupport langSupport = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport == null) {
            throw new IllegalStateException("No current language support".toString());
        }
        LangSupport languageSupport = langSupport;
        return this.getProjectRoot(languageSupport);
    }

    @NotNull
    public final VirtualFile getProjectRoot(@NotNull LangSupport languageSupport) {
        Intrinsics.checkNotNullParameter((Object)languageSupport, (String)"languageSupport");
        Path path = this.getLearningInstallationContentRoot(languageSupport);
        if (path == null) {
            throw new IllegalStateException(("No path for learning project for " + languageSupport).toString());
        }
        Path learningInstallationContentRoot = path;
        Path projectPath = languageSupport.getLearningProjectPath(learningInstallationContentRoot);
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(projectPath);
        if (virtualFile == null) {
            throw new IllegalStateException(("Cannot to convert " + projectPath + " to virtual file").toString());
        }
        return virtualFile;
    }

    public final void simpleInstallAndOpenLearningProject(@NotNull Path contentRoot, @NotNull LangSupport langSupport, @NotNull OpenProjectTask openProjectTask, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        Intrinsics.checkNotNullParameter((Object)langSupport, (String)"langSupport");
        Intrinsics.checkNotNullParameter((Object)openProjectTask, (String)"openProjectTask");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        Path actualContentRoot = this.copyLearningProjectFiles(contentRoot, langSupport);
        if (actualContentRoot == null) {
            return;
        }
        this.createVersionFile(actualContentRoot);
        this.openOrImportLearningProject(actualContentRoot, openProjectTask, langSupport, (Function1<? super Project, Unit>)((Function1)arg_0 -> ProjectUtils.simpleInstallAndOpenLearningProject$lambda$0(postInitCallback, arg_0)));
    }

    private final void updateLearningModificationTimestamp(Project it) {
        PropertiesComponent.getInstance((Project)it).setValue(LEARNING_PROJECT_MODIFICATION, String.valueOf(System.currentTimeMillis()));
    }

    private final void openOrImportLearningProject(Path contentRoot, OpenProjectTask openProjectTask, LangSupport langSupport, Function1<? super Project, Unit> postInitCallback) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(langSupport.getLearningProjectPath(contentRoot));
        if (virtualFile == null) {
            throw new IllegalStateException("Copied Learn project folder is null".toString());
        }
        VirtualFile projectDirectoryVirtualFile = virtualFile;
        OpenProjectTask task2 = OpenProjectTask.copy$default((OpenProjectTask)openProjectTask, (boolean)false, (boolean)false, null, (boolean)false, (boolean)false, null, null, (boolean)false, null, (int)0, (int)0, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (boolean)false, ProjectUtils::openOrImportLearningProject$lambda$0, null, null, (boolean)false, null, null, null, (boolean)false, (int)0x1FDFFFF, null);
        ActionsKt.invokeLater$default(null, () -> ProjectUtils.openOrImportLearningProject$lambda$1(contentRoot, langSupport, projectDirectoryVirtualFile, task2, postInitCallback), (int)1, null);
    }

    private final Path copyLearningProjectFiles(Path newContentDirectory, LangSupport langSupport) {
        Path targetDirectory = newContentDirectory;
        File file = targetDirectory.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        if (!LangSupport.copyLearningProjectFiles$default(langSupport, file, null, 2, null)) {
            Path path = (Path)ActionsKt.invokeAndWaitIfNeeded$default(null, () -> ProjectUtils.copyLearningProjectFiles$lambda$0(langSupport), (int)1, null);
            if (path == null) {
                return null;
            }
            targetDirectory = path;
            File file2 = targetDirectory.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            if (!LangSupport.copyLearningProjectFiles$default(langSupport, file2, null, 2, null)) {
                ActionsKt.invokeLater$default(null, ProjectUtils::copyLearningProjectFiles$lambda$1, (int)1, null);
                throw new IllegalStateException("Cannot create learning demo project. See LOG files for details.".toString());
            }
        }
        Path path = langSupport.getLearningProjectPath(targetDirectory);
        LangManager.Companion.getInstance().setLearningProjectPath(langSupport, ((Object)path.toAbsolutePath()).toString());
        return targetDirectory;
    }

    @NotNull
    public final URL learningProjectUrl(@NotNull LangSupport langSupport) {
        Intrinsics.checkNotNullParameter((Object)langSupport, (String)"langSupport");
        URL uRL = langSupport.getClass().getClassLoader().getResource(langSupport.getProjectResourcePath());
        if (uRL == null) {
            throw new IllegalArgumentException("No project " + langSupport.getProjectResourcePath() + " in resources for " + langSupport.getPrimaryLanguage() + " IDE learning course");
        }
        return uRL;
    }

    private final Path chooseParentDirectoryForLearningProject(LangSupport langSupport) {
        Object[] objectArray = new Object[]{langSupport.getContentRootDirectoryName()};
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false).withTitle(LearnBundle.INSTANCE.message("learn.project.initializing.choose.place", objectArray));
        FileChooserDialogImpl dialog2 = new FileChooserDialogImpl(descriptor, null);
        Ref.ObjectRef result = new Ref.ObjectRef();
        dialog2.choose(VfsUtil.getUserHomeDir(), arg_0 -> ProjectUtils.chooseParentDirectoryForLearningProject$lambda$0(result, arg_0));
        List list = (List)result.element;
        if (list == null) {
            return null;
        }
        List directories = list;
        if (directories.isEmpty()) {
            throw new IllegalStateException("No directory selected for the project".toString());
        }
        VirtualFile chosen = (VirtualFile)CollectionsKt.single((List)directories);
        String string = chosen.getCanonicalPath();
        if (string == null) {
            throw new IllegalStateException(("No canonical path for " + chosen).toString());
        }
        String canonicalPath = string;
        return new File(canonicalPath, langSupport.getContentRootDirectoryName()).toPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createVersionFile(Path newProjectDirectory) {
        Closeable closeable = new PrintWriter(newProjectDirectory.resolve(FEATURE_TRAINER_VERSION).toFile(), "UTF-8");
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)closeable;
            boolean bl = false;
            it.println(UtilsKt.getFeatureTrainerVersion());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final boolean isSameVersion(Path versionFile) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(versionFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return false;
        }
        Optional<String> res = Files.lines(versionFile).findFirst();
        if (res.isPresent()) {
            return Intrinsics.areEqual((Object)UtilsKt.getFeatureTrainerVersion(), (Object)res.get());
        }
        return false;
    }

    private final Path versionFile(Path dest) {
        return dest.resolve(FEATURE_TRAINER_VERSION);
    }

    /*
     * WARNING - void declaration
     */
    public final void markDirectoryAsSourcesRoot(@NotNull Project project, @NotNull String pathToSources) {
        Object object;
        ModifiableRootModel rootsModel;
        VirtualFile sourcesRoot;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)pathToSources, (String)"pathToSources");
            Object[] modules = ModuleManager.Companion.getInstance(project).getModules();
            if (modules.length > 1) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object[] $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ProjectUtils.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                $this$thisLogger$iv = modules;
                Logger logger2 = logger;
                boolean $i$f$map = false;
                void var6_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_15 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                logger2.error("The learning project has more than one module: " + (List)destination$iv$iv);
            }
            Module module = (Module)ArraysKt.first((Object[])modules);
            String string = project.getBasePath();
            Intrinsics.checkNotNull((Object)string);
            String sourcesPath = string + "/" + pathToSources;
            sourcesRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(sourcesPath);
            if (sourcesRoot == null) {
                String status = !new File(sourcesPath).exists() ? "does not exist" : (new File(sourcesPath).isDirectory() ? "existed directory" : "it is regular file");
                throw new IllegalStateException(("Failed to find directory with source files: " + sourcesPath + " (" + status + ")").toString());
            }
            ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"getModifiableModel(...)");
            rootsModel = modifiableRootModel;
            ContentEntry[] contentEntryArray = rootsModel.getContentEntries();
            Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
            for (Object object2 : (Object[])contentEntryArray) {
                ContentEntry it = (ContentEntry)object2;
                boolean bl = false;
                VirtualFile contentEntryFile = it.getFile();
                if (!(contentEntryFile != null && VfsUtilCore.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)sourcesRoot, (boolean)false))) continue;
                object = object2;
                break block5;
            }
            object = null;
        }
        ContentEntry contentEntry = (ContentEntry)object;
        if (contentEntry == null) {
            throw new IllegalStateException(("Failed to find content entry for file: " + sourcesRoot.getName()).toString());
        }
        ContentEntry contentEntry2 = contentEntry;
        contentEntry2.addSourceFolder(sourcesRoot, false);
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>((Object)rootsModel){

            public final void invoke() {
                ((ModifiableRootModel)this.receiver).commit();
            }
        }));
        project.save();
    }

    @RequiresBackgroundThread
    public final void restoreProject(@NotNull LangSupport languageSupport, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)languageSupport, (String)"languageSupport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableFuture done = new CompletableFuture();
        AppUIExecutor.onWriteThread().withDocumentsCommitted(project).submit(() -> ProjectUtils.restoreProject$lambda$0(project, languageSupport, done));
        Boolean success = (Boolean)done.get();
        if (!success.booleanValue()) {
            ProjectUtils $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ProjectUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("IFT Learning project files refresh failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isEmptyDir(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Closeable closeable = Files.newDirectoryStream(path);
            Throwable throwable = null;
            try {
                DirectoryStream directory = (DirectoryStream)closeable;
                boolean bl = false;
                boolean bl2 = !directory.iterator().hasNext();
                return bl2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return false;
    }

    private static final Path getLearningInstallationContentRoot$lambda$0(LangSupport $langSupport) {
        return INSTANCE.chooseParentDirectoryForLearningProject($langSupport);
    }

    private static final Unit simpleInstallAndOpenLearningProject$lambda$0(Function1 $postInitCallback, Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.updateLearningModificationTimestamp(it);
        $postInitCallback.invoke((Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit openOrImportLearningProject$lambda$0(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ProjectUtil.getNOTIFICATIONS_SILENT_MODE().set((UserDataHolder)it, (Object)true);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit openOrImportLearningProject$lambda$1(Path $contentRoot, LangSupport $langSupport, VirtualFile $projectDirectoryVirtualFile, OpenProjectTask $task, Function1 $postInitCallback) {
        Project project;
        TrustedPaths.Companion.getInstance().setProjectPathTrusted($contentRoot, true);
        int confirmOpenNewProject = GeneralSettings.Companion.getInstance().getConfirmOpenNewProject();
        if (confirmOpenNewProject == 2) {
            GeneralSettings.Companion.getInstance().setConfirmOpenNewProject(1);
        }
        try {
            project = $langSupport.openOrImportLearningProject($projectDirectoryVirtualFile, $task);
        }
        finally {
            if (confirmOpenNewProject == 2) {
                GeneralSettings.Companion.getInstance().setConfirmOpenNewProject(confirmOpenNewProject);
            }
        }
        Project project2 = project;
        $postInitCallback.invoke((Object)project2);
        return Unit.INSTANCE;
    }

    private static final Path copyLearningProjectFiles$lambda$0(LangSupport $langSupport) {
        return INSTANCE.chooseParentDirectoryForLearningProject($langSupport);
    }

    private static final Unit copyLearningProjectFiles$lambda$1() {
        Messages.showInfoMessage((String)LearnBundle.INSTANCE.message("learn.project.initializing.cannot.create.message", new Object[0]), (String)LearnBundle.INSTANCE.message("learn.project.initializing.cannot.create.title", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final void chooseParentDirectoryForLearningProject$lambda$0(Ref.ObjectRef $result, List it) {
        $result.element = it;
    }

    private static final void restoreProject$lambda$0(Project $project, LangSupport $languageSupport, CompletableFuture $done) {
        try {
            String string = PropertiesComponent.getInstance((Project)$project).getValue(LEARNING_PROJECT_MODIFICATION);
            long stamp = string != null ? Long.parseLong(string) : 0L;
            List needReplace = new ArrayList();
            List validContent = new ArrayList();
            List directories = new ArrayList();
            VirtualFile root = INSTANCE.getProjectRoot($languageSupport);
            Path path = root.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            Path contentRootPath = $languageSupport.getContentRootPath(path);
            Set<Path> protectedPaths = $languageSupport.getProtectedDirs($project);
            Files.walkFileTree(contentRootPath, (FileVisitor<? super Path>)new FileVisitor<Path>(contentRootPath, protectedPaths, (List<Path>)directories, stamp, (List<Path>)needReplace, (List<Path>)validContent){
                final /* synthetic */ Path $contentRootPath;
                final /* synthetic */ Set<Path> $protectedPaths;
                final /* synthetic */ List<Path> $directories;
                final /* synthetic */ long $stamp;
                final /* synthetic */ List<Path> $needReplace;
                final /* synthetic */ List<Path> $validContent;
                {
                    this.$contentRootPath = $contentRootPath;
                    this.$protectedPaths = $protectedPaths;
                    this.$directories = $directories;
                    this.$stamp = $stamp;
                    this.$needReplace = $needReplace;
                    this.$validContent = $validContent;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    FileVisitResult fileVisitResult;
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    if (Intrinsics.areEqual((Object)dir, (Object)this.$contentRootPath)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!ProjectUtils.access$getProtectedDirNames$p().contains(PathsKt.getName((Path)dir))) {
                        boolean bl;
                        block6: {
                            Iterable $this$any$iv = this.$protectedPaths;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    Path it = (Path)element$iv;
                                    boolean bl2 = false;
                                    if (!it.startsWith(dir)) continue;
                                    bl = true;
                                    break block6;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) {
                            this.$directories.add(dir);
                            fileVisitResult = FileVisitResult.CONTINUE;
                            return fileVisitResult;
                        }
                    }
                    fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                    return fileVisitResult;
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    String fileName = PathsKt.getName((Path)file);
                    if (Intrinsics.areEqual((Object)fileName, (Object)"feature-trainer-version.txt") || StringsKt.startsWith$default((String)fileName, (String)".git", (boolean)false, (int)2, null) || this.$protectedPaths.contains(file) || StringsKt.endsWith$default((String)fileName, (String)".iml", (boolean)false, (int)2, null)) {
                        return FileVisitResult.CONTINUE;
                    }
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    FileTime fileTime = Files.getLastModifiedTime(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                    boolean bl = fileTime.toMillis() > this.$stamp ? this.$needReplace.add(file) : this.$validContent.add(file);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
            Ref.BooleanRef modified = new Ref.BooleanRef();
            for (Path path2 : needReplace) {
                PathKt.delete$default((Path)path2, (boolean)false, (int)1, null);
                modified.element = true;
            }
            File contentRoodDirectory = contentRootPath.toFile();
            Intrinsics.checkNotNull((Object)contentRoodDirectory);
            $languageSupport.copyLearningProjectFiles(contentRoodDirectory, arg_0 -> ProjectUtils.restoreProject$lambda$0$0(needReplace, validContent, modified, arg_0));
            for (Path path3 : directories) {
                if (!INSTANCE.isEmptyDir(path3)) continue;
                modified.element = true;
                PathKt.delete$default((Path)path3, (boolean)false, (int)1, null);
            }
            if (modified.element) {
                PropertiesComponent.getInstance((Project)$project).setValue(LEARNING_PROJECT_MODIFICATION, String.valueOf(System.currentTimeMillis()));
            }
            $done.complete(true);
        }
        catch (Exception e) {
            $done.complete(false);
            throw e;
        }
    }

    private static final boolean restoreProject$lambda$0$0(List $needReplace, List $validContent, Ref.BooleanRef $modified, File it) {
        Path path = it.toPath();
        boolean needCopy = $needReplace.contains(path) || !$validContent.contains(path);
        $modified.element = needCopy || $modified.element;
        return needCopy;
    }

    public static final /* synthetic */ Path access$getLearningInstallationContentRoot(ProjectUtils $this, LangSupport langSupport) {
        return $this.getLearningInstallationContentRoot(langSupport);
    }

    public static final /* synthetic */ boolean access$isSameVersion(ProjectUtils $this, Path versionFile) {
        return $this.isSameVersion(versionFile);
    }

    public static final /* synthetic */ Path access$versionFile(ProjectUtils $this, Path dest) {
        return $this.versionFile(dest);
    }

    public static final /* synthetic */ void access$openOrImportLearningProject(ProjectUtils $this, Path contentRoot, OpenProjectTask openProjectTask, LangSupport langSupport, Function1 postInitCallback) {
        $this.openOrImportLearningProject(contentRoot, openProjectTask, langSupport, (Function1<? super Project, Unit>)postInitCallback);
    }

    public static final /* synthetic */ HashSet access$getProtectedDirNames$p() {
        return protectedDirNames;
    }

    static {
        Object[] objectArray = new String[]{".idea", ".git", "git", "venv"};
        protectedDirNames = SetsKt.hashSetOf((Object[])objectArray);
    }
}

