\name{HConcaveImageFilter}
\alias{HConcaveImageFilter}
\title{HConcaveImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Identify local minima whose depth below the baseline is greater than
h.
HConcaveImageFilter}
\details{
HConcaveImageFilter extract local minima that are more than h intensity units below the
(local) background. This has the effect of extracting objects that are
darker than the background by at least h intensity units.
This filter uses the HMinimaImageFilter .
Geodesic morphology and the H-Convex algorithm is described in Chapter
6 of Pierre Soille's book "Morphological Image Analysis: Principles
and Applications", Second Edition, Springer, 2003.
See:
GrayscaleGeodesicDilateImageFilter , HMaximaImageFilter ,
MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter
HConcave for the procedural interface
itk::HConcaveImageFilter for the Doxygen on the original ITK class.
HConcaveImageFilter}
%C++ includes: sitkHConcaveImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{double GetHeight() const:}{
Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ HConcaveImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{Self SetHeight(double Height):}{
Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~HConcaveImageFilter():}{
Destructor
}
}
}
