/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkDICOMOrientImageFilter_h
#define sitkDICOMOrientImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class DICOMOrientImageFilter
\brief Permute axes and flip images as needed to obtain an approximation to the desired orientation.

The physical location of all pixels in the image remains the same, but the meta-data and the ordering of the stored pixels may change.

DICOMOrientImageFilter depends on a set of constants that describe all possible labels. Directions are labeled in terms of following pairs:

\li Left and Right (Subject's left and right)

\li Anterior and Posterior (Subject's front and back)

\li Inferior and Superior (Subject's bottom and top, i.e. feet and head)




The initials of these directions are used in a 3 letter code in the enumerated type OrientationEnum. The initials are given fastest moving index first, second fastest second, third fastest third, where the label's direction indicates increasing values.

An ITK image with an identity direction cosine matrix is in LPS (Left, Posterior, Superior) orientation as defined by the DICOM standard.

 \f[ LPS = \begin{Bmatrix} from\ right\ to\ \textbf{L}eft \\ from\ anterior\ towards\ \textbf{P}osterior \\ from\ inferior\ towards\ \textbf{S}uperior \end{Bmatrix} \f] 

The output orientation is specified with SetDesiredCoordinateOrientation. The input coordinate orientation is computed from the input image's direction cosine matrix.
\sa itk::simple::DICOMOrient for the procedural interface
\sa itk::DICOMOrientImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT DICOMOrientImageFilter : public ImageFilter {
    public:
      using Self = DICOMOrientImageFilter;

      /** Destructor */
      virtual ~DICOMOrientImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      DICOMOrientImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = typelist2::append<BasicPixelIDTypeList, VectorPixelIDTypeList>::type;
      /** Custom public declarations */
      static std::string GetOrientationFromDirectionCosines( const std::vector<double> &direction );
   static std::vector<double> GetDirectionCosinesFromOrientation( const std::string &str );

\

      /**
       * Set/Get the desired coordinate orientation for the output image
       */
      SITK_RETURN_SELF_TYPE_HEADER SetDesiredCoordinateOrientation ( std::string DesiredCoordinateOrientation ) { this->m_DesiredCoordinateOrientation = DesiredCoordinateOrientation; return *this; }

      /**
       * Set/Get the desired coordinate orientation for the output image
       */
      std::string GetDesiredCoordinateOrientation() const { return this->m_DesiredCoordinateOrientation; }
     /**
      * Get flip axes.

This value is computed during Update.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     std::vector<bool> GetFlipAxes() const { return this->m_FlipAxes; };

     /**
      * Get axes permute order.

This value is computed during Update.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     std::vector<unsigned int> GetPermuteOrder() const { return this->m_PermuteOrder; };


      /** Name of this class */
      std::string GetName() const { return std::string ("DICOMOrientImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::string  m_DesiredCoordinateOrientation{std::string("LPS")};


      std::vector<bool> m_FlipAxes{std::vector<bool>()};

      std::vector<unsigned int> m_PermuteOrder{std::vector<unsigned int>()};


    };

    /**\
     * \brief Permute axes and flip images as needed to obtain an approximation to the desired orientation.
     *
     * This function directly calls the execute method of DICOMOrientImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::DICOMOrientImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image DICOMOrient ( const Image& image1, std::string desiredCoordinateOrientation = std::string("LPS") );

     /** @} */
}
#endif
