import { FoldingRange } from 'vscode-languageserver-types';
import { Document, TagInformation } from '../documents';
/**
 *
 * 1. check tab and space counts for lines
 * 2. if there're mixing space and tab guess the tabSize otherwise we only need to compare the numbers of spaces or tabs between lines.
 */
export declare function indentBasedFoldingRangeForTag(document: Document, tag: TagInformation): FoldingRange[];
export interface LineRange {
    startLine: number;
    endLine: number;
}
export declare function indentBasedFoldingRange({ document, ranges, skipFold }: {
    document: Document;
    ranges?: LineRange[] | undefined;
    skipFold?: (startLine: number, startLineContent: string) => boolean;
}): FoldingRange[];
/**
 *
 * The indentation guessing is based on the indentation difference between lines.
 * And if the count equals, then the one used more often takes priority.
 */
export declare function guessTabSize(nonEmptyLines: Array<{
    spaceCount: number;
    tabCount: number;
}>): number;
