"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ptr16MathGlyphInfoNullable = exports.MathGlyphInfo = void 0;
const bin_composite_types_1 = require("@ot-builder/bin-composite-types");
const ot_layout_1 = require("@ot-builder/ot-layout");
const coverage_1 = require("../shared/coverage");
const glyph_value_map_1 = require("./glyph-value-map");
exports.MathGlyphInfo = {
    read(bv, gOrd) {
        const mathItalicsCorrection = bv.next(glyph_value_map_1.Ptr16GlyphMathValueRecordMap, gOrd);
        const topAccentAttachment = bv.next(glyph_value_map_1.Ptr16GlyphMathValueRecordMap, gOrd);
        const extendedShapes = bv.next(coverage_1.NullablePtr16GlyphCoverage, gOrd);
        const kernInfo = bv.next(glyph_value_map_1.Ptr16GlyphMathKernInfoMap, gOrd);
        return new ot_layout_1.Math.GlyphInfo(mathItalicsCorrection, topAccentAttachment, extendedShapes, kernInfo);
    },
    write(fr, gi, gOrd) {
        fr.push(glyph_value_map_1.Ptr16GlyphMathValueRecordMap, gi.italicCorrections, gOrd);
        fr.push(glyph_value_map_1.Ptr16GlyphMathValueRecordMap, gi.topAccentAttachments, gOrd);
        fr.push(coverage_1.NullablePtr16GlyphCoverage, gi.extendedShapes, gOrd);
        fr.push(glyph_value_map_1.Ptr16GlyphMathKernInfoMap, gi.kernInfos, gOrd);
    }
};
exports.Ptr16MathGlyphInfoNullable = (0, bin_composite_types_1.NullablePtr16)(exports.MathGlyphInfo);
//# sourceMappingURL=glyph-info.js.map