# Contributing to the Fortran standard library

Thank you for considering contributing to the Fortran standard library (*stdlib*).
Please review and follow these guidelines to make the contribution process
simple and effective for all involved. It will help communicate that you
respect the time of the community developers. In return, the community will
help to address your problem, evaluate changes, and guide you through your pull
requests.

By contributing to *stdlib*, you certify that you own or are allowed to share the
content of your contribution under the
[stdlib license](https://github.com/fortran-lang/stdlib/blob/HEAD/LICENSE).

* [Style](#style)
* [Reporting a bug](#reporting-a-bug)
* [Suggesting a feature](#suggesting-a-feature)
* [Workflow](#workflow)
* [General guidelines](#general-guidelines)
* [For new contributors](#for-new-contributors)


## Style

Please follow the
[Fortran stdlib style guide](https://github.com/fortran-lang/stdlib/blob/HEAD/STYLE_GUIDE.md)
for any Fortran code that you contribute.
This allows the community to focus on substance rather than style.

The style guide is a living document.
You are welcome to propose changes to the style guide by
[opening an issue](https://github.com/fortran-lang/stdlib/issues/new/choose) or
[starting a discussion](https://github.com/fortran-lang/stdlib/discussions/new).


## Reporting a bug

A bug is a *demonstrable problem* caused by the code in this repository.
Good bug reports are extremely valuable to the community—thank you!

Before opening a bug report:

1. Check if the issue has already been reported
   ([issues](https://github.com/fortran-lang/stdlib/issues)).
2. Check if it is still an issue or it has been fixed?
   Try to reproduce it with the latest version from the default branch.
3. Isolate the problem and create a minimal test case.

A good bug report should include all information needed to reproduce the bug.
Please be as detailed as possible:

1. Which version of *stdlib* are you using?
   Which compiler version are you using?
   Which platform and architecture are you on?
   Please be specific.
2. What are the steps to reproduce the issue?
3. What is the expected outcome?
4. What happens instead?

This information will help the community to diagnose the issue quickly and with
minimal back-and-forth.


## Suggesting a feature

Before suggesting a new feature, take a moment to find out if it fits the scope
of the project, or if it has already been discussed. It is up to you to provide
a strong argument to convince the community of the benefits of this feature.
Please provide as many details and context as possible. If applicable, include a
mocked-up snippet of what the output or behavior would look like with this
feature implemented. “Crazy,” out-of-the-box ideas are especially welcome.
It is quite possible we have not considered such solutions yet.


## Workflow

The general workflow is documented in
[this document](https://github.com/fortran-lang/stdlib/blob/HEAD/WORKFLOW.md)

The workflow guide is a living document.
You are welcome to propose changes to the workflow by
[opening an issue](https://github.com/fortran-lang/stdlib/issues/new/choose) or
[starting a discussion](https://github.com/fortran-lang/stdlib/discussions/new).


## General guidelines

* A PR should implement *only one* feature or bug fix.
* Do not commit changes to files that are irrelevant to your feature or bug fix.
* Smaller PRs are better than large PRs, and will lead to a shorter review and
  merge cycle.
* Add tests for your feature or bug fix to be sure that it stays functional and useful.
* Include new features and changes in the
  [CHANGELOG](https://github.com/fortran-lang/stdlib/blob/master/CHANGELOG.md)
* Be open to constructive criticism and requests for improving your code.
* Again, please follow the
  [Fortran stdlib style guide](https://github.com/fortran-lang/stdlib/blob/HEAD/STYLE_GUIDE.md).


## For new contributors

If you have never created a pull request before, welcome :tada:.
You can learn how from
[this great tutorial](https://app.egghead.io/courses/how-to-contribute-to-an-open-source-project-on-github).

Don’t know where to start?
You can start by looking through the list of
[open issues](https://github.com/fortran-lang/stdlib/issues).
