// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// For Connector for SCEP for general-purpose. An object containing information
// about the specified connector's SCEP challenge passwords.
type Challenge struct {

	// The Amazon Resource Name (ARN) of the challenge.
	Arn *string

	// The Amazon Resource Name (ARN) of the connector.
	ConnectorArn *string

	// The date and time that the challenge was created.
	CreatedAt *time.Time

	// The SCEP challenge password, in UUID format.
	Password *string

	// The date and time that the challenge was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains details about the connector's challenge.
type ChallengeMetadata struct {

	// The Amazon Resource Name (ARN) of the challenge.
	Arn *string

	// The Amazon Resource Name (ARN) of the connector.
	ConnectorArn *string

	// The date and time that the connector was created.
	CreatedAt *time.Time

	// The date and time that the connector was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Details about the specified challenge, returned by the [GetChallengeMetadata] action.
//
// [GetChallengeMetadata]: https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_GetChallengeMetadata.html
type ChallengeMetadataSummary struct {

	// The Amazon Resource Name (ARN) of the challenge.
	Arn *string

	// The Amazon Resource Name (ARN) of the connector.
	ConnectorArn *string

	// The date and time that the challenge was created.
	CreatedAt *time.Time

	// The date and time that the challenge was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Connector for SCEP is a service that links Amazon Web Services Private
// Certificate Authority to your SCEP-enabled devices. The connector brokers the
// exchange of certificates from Amazon Web Services Private CA to your
// SCEP-enabled devices and mobile device management systems. The connector is a
// complex type that contains the connector's configuration settings.
type Connector struct {

	// The Amazon Resource Name (ARN) of the connector.
	Arn *string

	// The Amazon Resource Name (ARN) of the certificate authority associated with the
	// connector.
	CertificateAuthorityArn *string

	// The date and time that the connector was created.
	CreatedAt *time.Time

	// The connector's HTTPS public SCEP URL.
	Endpoint *string

	// Contains settings relevant to the mobile device management system that you
	// chose for the connector. If you didn't configure MobileDeviceManagement , then
	// the connector is for general-purpose use and this object is empty.
	MobileDeviceManagement MobileDeviceManagement

	// Contains OpenID Connect (OIDC) parameters for use with Connector for SCEP for
	// Microsoft Intune. For more information about using Connector for SCEP for
	// Microsoft Intune, see [Using Connector for SCEP for Microsoft Intune].
	//
	// [Using Connector for SCEP for Microsoft Intune]: https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html
	OpenIdConfiguration *OpenIdConfiguration

	// The connector's status.
	Status ConnectorStatus

	// Information about why connector creation failed, if status is FAILED .
	StatusReason ConnectorStatusReason

	// The connector type.
	Type ConnectorType

	// The date and time that the connector was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Lists the Amazon Web Services Private CA SCEP connectors belonging to your
// Amazon Web Services account.
type ConnectorSummary struct {

	// The Amazon Resource Name (ARN) of the connector.
	Arn *string

	// The Amazon Resource Name (ARN) of the connector's associated certificate
	// authority.
	CertificateAuthorityArn *string

	// The date and time that the challenge was created.
	CreatedAt *time.Time

	// The connector's HTTPS public SCEP URL.
	Endpoint *string

	// Contains settings relevant to the mobile device management system that you
	// chose for the connector. If you didn't configure MobileDeviceManagement , then
	// the connector is for general-purpose use and this object is empty.
	MobileDeviceManagement MobileDeviceManagement

	// Contains OpenID Connect (OIDC) parameters for use with Microsoft Intune.
	OpenIdConfiguration *OpenIdConfiguration

	// The connector's status. Status can be creating, active, deleting, or failed.
	Status ConnectorStatus

	// Information about why connector creation failed, if status is FAILED .
	StatusReason ConnectorStatusReason

	// The connector type.
	Type ConnectorType

	// The date and time that the challenge was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains configuration details for use with Microsoft Intune. For information
// about using Connector for SCEP for Microsoft Intune, see [Using Connector for SCEP for Microsoft Intune].
//
// When you use Connector for SCEP for Microsoft Intune, certain functionalities
// are enabled by accessing Microsoft Intune through the Microsoft API. Your use of
// the Connector for SCEP and accompanying Amazon Web Services services doesn't
// remove your need to have a valid license for your use of the Microsoft Intune
// service. You should also review the [Microsoft Intune® App Protection Policies].
//
// [Microsoft Intune® App Protection Policies]: https://learn.microsoft.com/en-us/mem/intune/apps/app-protection-policy
// [Using Connector for SCEP for Microsoft Intune]: https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html
type IntuneConfiguration struct {

	// The directory (tenant) ID from your Microsoft Entra ID app registration.
	//
	// This member is required.
	AzureApplicationId *string

	// The primary domain from your Microsoft Entra ID app registration.
	//
	// This member is required.
	Domain *string

	noSmithyDocumentSerde
}

// If you don't supply a value, by default Connector for SCEP creates a connector
// for general-purpose use. A general-purpose connector is designed to work with
// clients or endpoints that support the SCEP protocol, except Connector for SCEP
// for Microsoft Intune. For information about considerations and limitations with
// using Connector for SCEP, see [Considerations and Limitations].
//
// If you provide an IntuneConfiguration , Connector for SCEP creates a connector
// for use with Microsoft Intune, and you manage the challenge passwords using
// Microsoft Intune. For more information, see [Using Connector for SCEP for Microsoft Intune].
//
// The following types satisfy this interface:
//
//	MobileDeviceManagementMemberIntune
//
// [Considerations and Limitations]: https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlc4scep-considerations-limitations.html
// [Using Connector for SCEP for Microsoft Intune]: https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html
type MobileDeviceManagement interface {
	isMobileDeviceManagement()
}

// Configuration settings for use with Microsoft Intune. For information about
// using Connector for SCEP for Microsoft Intune, see [Using Connector for SCEP for Microsoft Intune].
//
// [Using Connector for SCEP for Microsoft Intune]: https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html
type MobileDeviceManagementMemberIntune struct {
	Value IntuneConfiguration

	noSmithyDocumentSerde
}

func (*MobileDeviceManagementMemberIntune) isMobileDeviceManagement() {}

// Contains OpenID Connect (OIDC) parameters for use with Microsoft Intune. For
// more information about using Connector for SCEP for Microsoft Intune, see [Using Connector for SCEP for Microsoft Intune].
//
// [Using Connector for SCEP for Microsoft Intune]: https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html
type OpenIdConfiguration struct {

	// The audience value to copy into your Microsoft Entra app registration's OIDC.
	Audience *string

	// The issuer value to copy into your Microsoft Entra app registration's OIDC.
	Issuer *string

	// The subject value to copy into your Microsoft Entra app registration's OIDC.
	Subject *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isMobileDeviceManagement() {}
