//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armazurestackhci_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/azurestackhci/armazurestackhci/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/preview/2023-09-01-preview/examples/GetVirtualMachineInstance.json
func ExampleVirtualMachineInstancesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armazurestackhci.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVirtualMachineInstancesClient().Get(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachineInstance = armazurestackhci.VirtualMachineInstance{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.AzureStackHCI/virtualMachineInstances"),
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default"),
	// 	ExtendedLocation: &armazurestackhci.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
	// 		Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
	// 	},
	// 	Properties: &armazurestackhci.VirtualMachineInstanceProperties{
	// 		HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
	// 			VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
	// 		},
	// 		NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
	// 			NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
	// 				{
	// 					ID: to.Ptr("test-nic"),
	// 			}},
	// 		},
	// 		OSProfile: &armazurestackhci.VirtualMachineInstancePropertiesOsProfile{
	// 			AdminUsername: to.Ptr("localadmin"),
	// 			ComputerName: to.Ptr("luamaster"),
	// 		},
	// 		ProvisioningState: to.Ptr(armazurestackhci.ProvisioningStateEnumSucceeded),
	// 		StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
	// 			ImageReference: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileImageReference{
	// 				ID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
	// 			},
	// 			VMConfigStoragePathID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/preview/2023-09-01-preview/examples/PutVirtualMachineInstanceWithGalleryImage.json
func ExampleVirtualMachineInstancesClient_BeginCreateOrUpdate_putVirtualMachineInstanceWithGalleryImage() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armazurestackhci.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineInstancesClient().BeginCreateOrUpdate(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM", armazurestackhci.VirtualMachineInstance{
		ExtendedLocation: &armazurestackhci.ExtendedLocation{
			Name: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
			Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
		},
		Properties: &armazurestackhci.VirtualMachineInstanceProperties{
			HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
				VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
			},
			NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
				NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
					{
						ID: to.Ptr("test-nic"),
					}},
			},
			OSProfile: &armazurestackhci.VirtualMachineInstancePropertiesOsProfile{
				AdminPassword: to.Ptr("password"),
				AdminUsername: to.Ptr("localadmin"),
				ComputerName:  to.Ptr("luamaster"),
			},
			SecurityProfile: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfile{
				EnableTPM: to.Ptr(true),
				UefiSettings: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfileUefiSettings{
					SecureBootEnabled: to.Ptr(true),
				},
			},
			StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
				ImageReference: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileImageReference{
					ID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
				},
				VMConfigStoragePathID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachineInstance = armazurestackhci.VirtualMachineInstance{
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default"),
	// 	ExtendedLocation: &armazurestackhci.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
	// 		Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
	// 	},
	// 	Properties: &armazurestackhci.VirtualMachineInstanceProperties{
	// 		HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
	// 			VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
	// 		},
	// 		NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
	// 			NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
	// 				{
	// 					ID: to.Ptr("test-nic"),
	// 			}},
	// 		},
	// 		OSProfile: &armazurestackhci.VirtualMachineInstancePropertiesOsProfile{
	// 			AdminUsername: to.Ptr("localadmin"),
	// 			ComputerName: to.Ptr("luamaster"),
	// 		},
	// 		ProvisioningState: to.Ptr(armazurestackhci.ProvisioningStateEnumSucceeded),
	// 		SecurityProfile: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfile{
	// 			EnableTPM: to.Ptr(true),
	// 			UefiSettings: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfileUefiSettings{
	// 				SecureBootEnabled: to.Ptr(true),
	// 			},
	// 		},
	// 		StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
	// 			ImageReference: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileImageReference{
	// 				ID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
	// 			},
	// 			VMConfigStoragePathID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/preview/2023-09-01-preview/examples/PutVirtualMachineInstanceWithMarketplaceGalleryImage.json
func ExampleVirtualMachineInstancesClient_BeginCreateOrUpdate_putVirtualMachineInstanceWithMarketplaceGalleryImage() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armazurestackhci.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineInstancesClient().BeginCreateOrUpdate(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM", armazurestackhci.VirtualMachineInstance{
		ExtendedLocation: &armazurestackhci.ExtendedLocation{
			Name: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
			Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
		},
		Properties: &armazurestackhci.VirtualMachineInstanceProperties{
			HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
				VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
			},
			NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
				NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
					{
						ID: to.Ptr("test-nic"),
					}},
			},
			OSProfile: &armazurestackhci.VirtualMachineInstancePropertiesOsProfile{
				AdminPassword: to.Ptr("password"),
				AdminUsername: to.Ptr("localadmin"),
				ComputerName:  to.Ptr("luamaster"),
			},
			SecurityProfile: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfile{
				EnableTPM: to.Ptr(true),
				UefiSettings: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfileUefiSettings{
					SecureBootEnabled: to.Ptr(true),
				},
			},
			StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
				ImageReference: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileImageReference{
					ID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image"),
				},
				VMConfigStoragePathID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachineInstance = armazurestackhci.VirtualMachineInstance{
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default"),
	// 	ExtendedLocation: &armazurestackhci.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
	// 		Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
	// 	},
	// 	Properties: &armazurestackhci.VirtualMachineInstanceProperties{
	// 		HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
	// 			VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
	// 		},
	// 		NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
	// 			NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
	// 				{
	// 					ID: to.Ptr("test-nic"),
	// 			}},
	// 		},
	// 		OSProfile: &armazurestackhci.VirtualMachineInstancePropertiesOsProfile{
	// 			AdminUsername: to.Ptr("localadmin"),
	// 			ComputerName: to.Ptr("luamaster"),
	// 		},
	// 		ProvisioningState: to.Ptr(armazurestackhci.ProvisioningStateEnumSucceeded),
	// 		SecurityProfile: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfile{
	// 			EnableTPM: to.Ptr(true),
	// 			UefiSettings: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfileUefiSettings{
	// 				SecureBootEnabled: to.Ptr(true),
	// 			},
	// 		},
	// 		StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
	// 			ImageReference: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileImageReference{
	// 				ID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image"),
	// 			},
	// 			VMConfigStoragePathID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/preview/2023-09-01-preview/examples/PutVirtualMachineInstanceWithOsDisk.json
func ExampleVirtualMachineInstancesClient_BeginCreateOrUpdate_putVirtualMachineInstanceWithOsDisk() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armazurestackhci.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineInstancesClient().BeginCreateOrUpdate(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM", armazurestackhci.VirtualMachineInstance{
		ExtendedLocation: &armazurestackhci.ExtendedLocation{
			Name: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
			Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
		},
		Properties: &armazurestackhci.VirtualMachineInstanceProperties{
			HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
				VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
			},
			NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
				NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
					{
						ID: to.Ptr("test-nic"),
					}},
			},
			SecurityProfile: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfile{
				EnableTPM: to.Ptr(true),
				UefiSettings: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfileUefiSettings{
					SecureBootEnabled: to.Ptr(true),
				},
			},
			StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
				OSDisk: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileOsDisk{
					ID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd"),
				},
				VMConfigStoragePathID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachineInstance = armazurestackhci.VirtualMachineInstance{
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default"),
	// 	ExtendedLocation: &armazurestackhci.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
	// 		Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
	// 	},
	// 	Properties: &armazurestackhci.VirtualMachineInstanceProperties{
	// 		HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
	// 			VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
	// 		},
	// 		NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
	// 			NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
	// 				{
	// 					ID: to.Ptr("test-nic"),
	// 			}},
	// 		},
	// 		ProvisioningState: to.Ptr(armazurestackhci.ProvisioningStateEnumSucceeded),
	// 		SecurityProfile: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfile{
	// 			EnableTPM: to.Ptr(true),
	// 			UefiSettings: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfileUefiSettings{
	// 				SecureBootEnabled: to.Ptr(true),
	// 			},
	// 		},
	// 		StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
	// 			OSDisk: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileOsDisk{
	// 				ID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd"),
	// 			},
	// 			VMConfigStoragePathID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/preview/2023-09-01-preview/examples/PutVirtualMachineInstanceWithVMConfigAgent.json
func ExampleVirtualMachineInstancesClient_BeginCreateOrUpdate_putVirtualMachineInstanceWithVmConfigAgent() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armazurestackhci.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineInstancesClient().BeginCreateOrUpdate(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM", armazurestackhci.VirtualMachineInstance{
		ExtendedLocation: &armazurestackhci.ExtendedLocation{
			Name: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
			Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
		},
		Properties: &armazurestackhci.VirtualMachineInstanceProperties{
			HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
				VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
			},
			NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
				NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
					{
						ID: to.Ptr("test-nic"),
					}},
			},
			OSProfile: &armazurestackhci.VirtualMachineInstancePropertiesOsProfile{
				AdminPassword: to.Ptr("password"),
				AdminUsername: to.Ptr("localadmin"),
				ComputerName:  to.Ptr("luamaster"),
				WindowsConfiguration: &armazurestackhci.VirtualMachineInstancePropertiesOsProfileWindowsConfiguration{
					ProvisionVMConfigAgent: to.Ptr(true),
				},
			},
			SecurityProfile: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfile{
				EnableTPM: to.Ptr(true),
				UefiSettings: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfileUefiSettings{
					SecureBootEnabled: to.Ptr(true),
				},
			},
			StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
				ImageReference: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileImageReference{
					ID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
				},
				VMConfigStoragePathID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachineInstance = armazurestackhci.VirtualMachineInstance{
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default"),
	// 	ExtendedLocation: &armazurestackhci.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
	// 		Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
	// 	},
	// 	Properties: &armazurestackhci.VirtualMachineInstanceProperties{
	// 		HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
	// 			VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
	// 		},
	// 		InstanceView: &armazurestackhci.VirtualMachineInstanceView{
	// 			VMAgent: &armazurestackhci.VirtualMachineConfigAgentInstanceView{
	// 				Statuses: []*armazurestackhci.InstanceViewStatus{
	// 					{
	// 						Code: to.Ptr("Ok"),
	// 						DisplayStatus: to.Ptr("Ok"),
	// 						Level: to.Ptr(armazurestackhci.StatusLevelTypesInfo),
	// 						Message: to.Ptr("The agent is healthy"),
	// 						Time: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2009-06-15T05:45:30.000Z"); return t}()),
	// 				}},
	// 				VMConfigAgentVersion: to.Ptr("1.0.0"),
	// 			},
	// 		},
	// 		NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
	// 			NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
	// 				{
	// 					ID: to.Ptr("test-nic"),
	// 			}},
	// 		},
	// 		OSProfile: &armazurestackhci.VirtualMachineInstancePropertiesOsProfile{
	// 			AdminUsername: to.Ptr("localadmin"),
	// 			ComputerName: to.Ptr("luamaster"),
	// 		},
	// 		ProvisioningState: to.Ptr(armazurestackhci.ProvisioningStateEnumSucceeded),
	// 		SecurityProfile: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfile{
	// 			EnableTPM: to.Ptr(true),
	// 			UefiSettings: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfileUefiSettings{
	// 				SecureBootEnabled: to.Ptr(true),
	// 			},
	// 		},
	// 		StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
	// 			ImageReference: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileImageReference{
	// 				ID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
	// 			},
	// 			VMConfigStoragePathID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/preview/2023-09-01-preview/examples/DeleteVirtualMachineInstance.json
func ExampleVirtualMachineInstancesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armazurestackhci.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineInstancesClient().BeginDelete(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/preview/2023-09-01-preview/examples/UpdateVirtualMachineInstance.json
func ExampleVirtualMachineInstancesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armazurestackhci.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineInstancesClient().BeginUpdate(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM", armazurestackhci.VirtualMachineInstanceUpdateRequest{
		Properties: &armazurestackhci.VirtualMachineInstanceUpdateProperties{
			StorageProfile: &armazurestackhci.StorageProfileUpdate{
				DataDisks: []*armazurestackhci.StorageProfileUpdateDataDisksItem{
					{
						ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd"),
					}},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachineInstance = armazurestackhci.VirtualMachineInstance{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.AzureStackHCI/virtualMachineInstances"),
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default"),
	// 	ExtendedLocation: &armazurestackhci.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
	// 		Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
	// 	},
	// 	Properties: &armazurestackhci.VirtualMachineInstanceProperties{
	// 		HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
	// 			VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
	// 		},
	// 		NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
	// 			NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
	// 				{
	// 					ID: to.Ptr("test-nic"),
	// 			}},
	// 		},
	// 		OSProfile: &armazurestackhci.VirtualMachineInstancePropertiesOsProfile{
	// 			AdminUsername: to.Ptr("localadmin"),
	// 			ComputerName: to.Ptr("luamaster"),
	// 		},
	// 		ProvisioningState: to.Ptr(armazurestackhci.ProvisioningStateEnumSucceeded),
	// 		StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
	// 			DataDisks: []*armazurestackhci.VirtualMachineInstancePropertiesStorageProfileDataDisksItem{
	// 				{
	// 					ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd"),
	// 			}},
	// 			ImageReference: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileImageReference{
	// 				ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/preview/2023-09-01-preview/examples/StartVirtualMachineInstance.json
func ExampleVirtualMachineInstancesClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armazurestackhci.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineInstancesClient().BeginStart(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachineInstance = armazurestackhci.VirtualMachineInstance{
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default"),
	// 	ExtendedLocation: &armazurestackhci.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
	// 		Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
	// 	},
	// 	Properties: &armazurestackhci.VirtualMachineInstanceProperties{
	// 		HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
	// 			VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
	// 		},
	// 		NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
	// 			NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
	// 				{
	// 					ID: to.Ptr("test-nic"),
	// 			}},
	// 		},
	// 		OSProfile: &armazurestackhci.VirtualMachineInstancePropertiesOsProfile{
	// 			AdminUsername: to.Ptr("localadmin"),
	// 			ComputerName: to.Ptr("luamaster"),
	// 		},
	// 		ProvisioningState: to.Ptr(armazurestackhci.ProvisioningStateEnumSucceeded),
	// 		SecurityProfile: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfile{
	// 			EnableTPM: to.Ptr(true),
	// 			UefiSettings: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfileUefiSettings{
	// 				SecureBootEnabled: to.Ptr(true),
	// 			},
	// 		},
	// 		StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
	// 			ImageReference: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileImageReference{
	// 				ID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
	// 			},
	// 			VMConfigStoragePathID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/preview/2023-09-01-preview/examples/StopVirtualMachineInstance.json
func ExampleVirtualMachineInstancesClient_BeginStop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armazurestackhci.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineInstancesClient().BeginStop(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachineInstance = armazurestackhci.VirtualMachineInstance{
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default"),
	// 	ExtendedLocation: &armazurestackhci.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
	// 		Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
	// 	},
	// 	Properties: &armazurestackhci.VirtualMachineInstanceProperties{
	// 		HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
	// 			VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
	// 		},
	// 		NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
	// 			NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
	// 				{
	// 					ID: to.Ptr("test-nic"),
	// 			}},
	// 		},
	// 		OSProfile: &armazurestackhci.VirtualMachineInstancePropertiesOsProfile{
	// 			AdminUsername: to.Ptr("localadmin"),
	// 			ComputerName: to.Ptr("luamaster"),
	// 		},
	// 		ProvisioningState: to.Ptr(armazurestackhci.ProvisioningStateEnumSucceeded),
	// 		SecurityProfile: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfile{
	// 			EnableTPM: to.Ptr(true),
	// 			UefiSettings: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfileUefiSettings{
	// 				SecureBootEnabled: to.Ptr(true),
	// 			},
	// 		},
	// 		StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
	// 			ImageReference: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileImageReference{
	// 				ID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
	// 			},
	// 			VMConfigStoragePathID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/preview/2023-09-01-preview/examples/RestartVirtualMachineInstance.json
func ExampleVirtualMachineInstancesClient_BeginRestart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armazurestackhci.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineInstancesClient().BeginRestart(ctx, "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualMachineInstance = armazurestackhci.VirtualMachineInstance{
	// 	ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default"),
	// 	ExtendedLocation: &armazurestackhci.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
	// 		Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
	// 	},
	// 	Properties: &armazurestackhci.VirtualMachineInstanceProperties{
	// 		HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
	// 			VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
	// 		},
	// 		NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
	// 			NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
	// 				{
	// 					ID: to.Ptr("test-nic"),
	// 			}},
	// 		},
	// 		OSProfile: &armazurestackhci.VirtualMachineInstancePropertiesOsProfile{
	// 			AdminUsername: to.Ptr("localadmin"),
	// 			ComputerName: to.Ptr("luamaster"),
	// 		},
	// 		ProvisioningState: to.Ptr(armazurestackhci.ProvisioningStateEnumSucceeded),
	// 		SecurityProfile: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfile{
	// 			EnableTPM: to.Ptr(true),
	// 			UefiSettings: &armazurestackhci.VirtualMachineInstancePropertiesSecurityProfileUefiSettings{
	// 				SecureBootEnabled: to.Ptr(true),
	// 			},
	// 		},
	// 		StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
	// 			ImageReference: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileImageReference{
	// 				ID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
	// 			},
	// 			VMConfigStoragePathID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/preview/2023-09-01-preview/examples/ListVirtualMachineInstances.json
func ExampleVirtualMachineInstancesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armazurestackhci.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVirtualMachineInstancesClient().NewListPager("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VirtualMachineInstanceListResult = armazurestackhci.VirtualMachineInstanceListResult{
		// 	Value: []*armazurestackhci.VirtualMachineInstance{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.AzureStackHCI/virtualMachineInstances"),
		// 			ID: to.Ptr("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/Microsoft.HybridCompute/machines/DemoVM/providers/Microsoft.AzureStackHCI/virtualMachineInstances/default"),
		// 			ExtendedLocation: &armazurestackhci.ExtendedLocation{
		// 				Name: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
		// 				Type: to.Ptr(armazurestackhci.ExtendedLocationTypesCustomLocation),
		// 			},
		// 			Properties: &armazurestackhci.VirtualMachineInstanceProperties{
		// 				HardwareProfile: &armazurestackhci.VirtualMachineInstancePropertiesHardwareProfile{
		// 					VMSize: to.Ptr(armazurestackhci.VMSizeEnumDefault),
		// 				},
		// 				NetworkProfile: &armazurestackhci.VirtualMachineInstancePropertiesNetworkProfile{
		// 					NetworkInterfaces: []*armazurestackhci.VirtualMachineInstancePropertiesNetworkProfileNetworkInterfacesItem{
		// 						{
		// 							ID: to.Ptr("test-nic"),
		// 					}},
		// 				},
		// 				OSProfile: &armazurestackhci.VirtualMachineInstancePropertiesOsProfile{
		// 					AdminUsername: to.Ptr("localadmin"),
		// 					ComputerName: to.Ptr("luamaster"),
		// 				},
		// 				ProvisioningState: to.Ptr(armazurestackhci.ProvisioningStateEnumSucceeded),
		// 				StorageProfile: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfile{
		// 					ImageReference: &armazurestackhci.VirtualMachineInstancePropertiesStorageProfileImageReference{
		// 						ID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
		// 					},
		// 					VMConfigStoragePathID: to.Ptr("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}
