//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armsecuritydevops.ClientFactory type.
type ServerFactory struct {
	AzureDevOpsConnectorServer      AzureDevOpsConnectorServer
	AzureDevOpsConnectorStatsServer AzureDevOpsConnectorStatsServer
	AzureDevOpsOrgServer            AzureDevOpsOrgServer
	AzureDevOpsProjectServer        AzureDevOpsProjectServer
	AzureDevOpsRepoServer           AzureDevOpsRepoServer
	GitHubConnectorServer           GitHubConnectorServer
	GitHubConnectorStatsServer      GitHubConnectorStatsServer
	GitHubOwnerServer               GitHubOwnerServer
	GitHubRepoServer                GitHubRepoServer
	OperationsServer                OperationsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armsecuritydevops.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armsecuritydevops.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                               *ServerFactory
	trMu                              sync.Mutex
	trAzureDevOpsConnectorServer      *AzureDevOpsConnectorServerTransport
	trAzureDevOpsConnectorStatsServer *AzureDevOpsConnectorStatsServerTransport
	trAzureDevOpsOrgServer            *AzureDevOpsOrgServerTransport
	trAzureDevOpsProjectServer        *AzureDevOpsProjectServerTransport
	trAzureDevOpsRepoServer           *AzureDevOpsRepoServerTransport
	trGitHubConnectorServer           *GitHubConnectorServerTransport
	trGitHubConnectorStatsServer      *GitHubConnectorStatsServerTransport
	trGitHubOwnerServer               *GitHubOwnerServerTransport
	trGitHubRepoServer                *GitHubRepoServerTransport
	trOperationsServer                *OperationsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AzureDevOpsConnectorClient":
		initServer(s, &s.trAzureDevOpsConnectorServer, func() *AzureDevOpsConnectorServerTransport {
			return NewAzureDevOpsConnectorServerTransport(&s.srv.AzureDevOpsConnectorServer)
		})
		resp, err = s.trAzureDevOpsConnectorServer.Do(req)
	case "AzureDevOpsConnectorStatsClient":
		initServer(s, &s.trAzureDevOpsConnectorStatsServer, func() *AzureDevOpsConnectorStatsServerTransport {
			return NewAzureDevOpsConnectorStatsServerTransport(&s.srv.AzureDevOpsConnectorStatsServer)
		})
		resp, err = s.trAzureDevOpsConnectorStatsServer.Do(req)
	case "AzureDevOpsOrgClient":
		initServer(s, &s.trAzureDevOpsOrgServer, func() *AzureDevOpsOrgServerTransport {
			return NewAzureDevOpsOrgServerTransport(&s.srv.AzureDevOpsOrgServer)
		})
		resp, err = s.trAzureDevOpsOrgServer.Do(req)
	case "AzureDevOpsProjectClient":
		initServer(s, &s.trAzureDevOpsProjectServer, func() *AzureDevOpsProjectServerTransport {
			return NewAzureDevOpsProjectServerTransport(&s.srv.AzureDevOpsProjectServer)
		})
		resp, err = s.trAzureDevOpsProjectServer.Do(req)
	case "AzureDevOpsRepoClient":
		initServer(s, &s.trAzureDevOpsRepoServer, func() *AzureDevOpsRepoServerTransport {
			return NewAzureDevOpsRepoServerTransport(&s.srv.AzureDevOpsRepoServer)
		})
		resp, err = s.trAzureDevOpsRepoServer.Do(req)
	case "GitHubConnectorClient":
		initServer(s, &s.trGitHubConnectorServer, func() *GitHubConnectorServerTransport {
			return NewGitHubConnectorServerTransport(&s.srv.GitHubConnectorServer)
		})
		resp, err = s.trGitHubConnectorServer.Do(req)
	case "GitHubConnectorStatsClient":
		initServer(s, &s.trGitHubConnectorStatsServer, func() *GitHubConnectorStatsServerTransport {
			return NewGitHubConnectorStatsServerTransport(&s.srv.GitHubConnectorStatsServer)
		})
		resp, err = s.trGitHubConnectorStatsServer.Do(req)
	case "GitHubOwnerClient":
		initServer(s, &s.trGitHubOwnerServer, func() *GitHubOwnerServerTransport { return NewGitHubOwnerServerTransport(&s.srv.GitHubOwnerServer) })
		resp, err = s.trGitHubOwnerServer.Do(req)
	case "GitHubRepoClient":
		initServer(s, &s.trGitHubRepoServer, func() *GitHubRepoServerTransport { return NewGitHubRepoServerTransport(&s.srv.GitHubRepoServer) })
		resp, err = s.trGitHubRepoServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
